!function(mod){"object"==typeof exports&&"object"==typeof module?mod(require("../lib/codemirror"),require("../addon/search/searchcursor"),require("../addon/dialog/dialog"),require("../addon/edit/matchbrackets.js")):"function"==typeof define&&define.amd?define(["../lib/codemirror","../addon/search/searchcursor","../addon/dialog/dialog","../addon/edit/matchbrackets"],mod):mod(CodeMirror)}(function(CodeMirror){"use strict";var defaultKeymap=[{keys:"<Left>",type:"keyToKey",toKeys:"h"},{keys:"<Right>",type:"keyToKey",toKeys:"l"},{keys:"<Up>",type:"keyToKey",toKeys:"k"},{keys:"<Down>",type:"keyToKey",toKeys:"j"},{keys:"<Space>",type:"keyToKey",toKeys:"l"},{keys:"<BS>",type:"keyToKey",toKeys:"h",context:"normal"},{keys:"<C-Space>",type:"keyToKey",toKeys:"W"},{keys:"<C-BS>",type:"keyToKey",toKeys:"B",context:"normal"},{keys:"<S-Space>",type:"keyToKey",toKeys:"w"},{keys:"<S-BS>",type:"keyToKey",toKeys:"b",context:"normal"},{keys:"<C-n>",type:"keyToKey",toKeys:"j"},{keys:"<C-p>",type:"keyToKey",toKeys:"k"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"s",type:"keyToKey",toKeys:"cl",context:"normal"},{keys:"s",type:"keyToKey",toKeys:"c",context:"visual"},{keys:"S",type:"keyToKey",toKeys:"cc",context:"normal"},{keys:"S",type:"keyToKey",toKeys:"VdO",context:"visual"},{keys:"<Home>",type:"keyToKey",toKeys:"0"},{keys:"<End>",type:"keyToKey",toKeys:"$"},{keys:"<PageUp>",type:"keyToKey",toKeys:"<C-b>"},{keys:"<PageDown>",type:"keyToKey",toKeys:"<C-f>"},{keys:"<CR>",type:"keyToKey",toKeys:"j^",context:"normal"},{keys:"<Ins>",type:"action",action:"toggleOverwrite",context:"insert"},{keys:"H",type:"motion",motion:"moveToTopLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"M",type:"motion",motion:"moveToMiddleLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"L",type:"motion",motion:"moveToBottomLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"h",type:"motion",motion:"moveByCharacters",motionArgs:{forward:!1}},{keys:"l",type:"motion",motion:"moveByCharacters",motionArgs:{forward:!0}},{keys:"j",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,linewise:!0}},{keys:"k",type:"motion",motion:"moveByLines",motionArgs:{forward:!1,linewise:!0}},{keys:"gj",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:!0}},{keys:"gk",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:!1}},{keys:"w",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!1}},{keys:"W",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!1,bigWord:!0}},{keys:"e",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!0,inclusive:!0}},{keys:"E",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!0,bigWord:!0,inclusive:!0}},{keys:"b",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1}},{keys:"B",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1,bigWord:!0}},{keys:"ge",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!0,inclusive:!0}},{keys:"gE",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!0,bigWord:!0,inclusive:!0}},{keys:"{",type:"motion",motion:"moveByParagraph",motionArgs:{forward:!1,toJumplist:!0}},{keys:"}",type:"motion",motion:"moveByParagraph",motionArgs:{forward:!0,toJumplist:!0}},{keys:"<C-f>",type:"motion",motion:"moveByPage",motionArgs:{forward:!0}},{keys:"<C-b>",type:"motion",motion:"moveByPage",motionArgs:{forward:!1}},{keys:"<C-d>",type:"motion",motion:"moveByScroll",motionArgs:{forward:!0,explicitRepeat:!0}},{keys:"<C-u>",type:"motion",motion:"moveByScroll",motionArgs:{forward:!1,explicitRepeat:!0}},{keys:"gg",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!1,explicitRepeat:!0,linewise:!0,toJumplist:!0}},{keys:"G",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!0,explicitRepeat:!0,linewise:!0,toJumplist:!0}},{keys:"0",type:"motion",motion:"moveToStartOfLine"},{keys:"^",type:"motion",motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"+",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,toFirstChar:!0}},{keys:"-",type:"motion",motion:"moveByLines",motionArgs:{forward:!1,toFirstChar:!0}},{keys:"_",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,toFirstChar:!0,repeatOffset:-1}},{keys:"$",type:"motion",motion:"moveToEol",motionArgs:{inclusive:!0}},{keys:"%",type:"motion",motion:"moveToMatchedSymbol",motionArgs:{inclusive:!0,toJumplist:!0}},{keys:"f<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:!0,inclusive:!0}},{keys:"F<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:!1}},{keys:"t<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:!0,inclusive:!0}},{keys:"T<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:!1}},{keys:";",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:!0}},{keys:",",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:!1}},{keys:"'<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:!0,linewise:!0}},{keys:"`<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:!0}},{keys:"]`",type:"motion",motion:"jumpToMark",motionArgs:{forward:!0}},{keys:"[`",type:"motion",motion:"jumpToMark",motionArgs:{forward:!1}},{keys:"]'",type:"motion",motion:"jumpToMark",motionArgs:{forward:!0,linewise:!0}},{keys:"['",type:"motion",motion:"jumpToMark",motionArgs:{forward:!1,linewise:!0}},{keys:"]p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!0,isEdit:!0,matchIndent:!0}},{keys:"[p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!1,isEdit:!0,matchIndent:!0}},{keys:"]<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:!0,toJumplist:!0}},{keys:"[<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:!1,toJumplist:!0}},{keys:"|",type:"motion",motion:"moveToColumn"},{keys:"o",type:"motion",motion:"moveToOtherHighlightedEnd",context:"visual"},{keys:"O",type:"motion",motion:"moveToOtherHighlightedEnd",motionArgs:{sameLine:!0},context:"visual"},{keys:"d",type:"operator",operator:"delete"},{keys:"y",type:"operator",operator:"yank"},{keys:"c",type:"operator",operator:"change"},{keys:">",type:"operator",operator:"indent",operatorArgs:{indentRight:!0}},{keys:"<",type:"operator",operator:"indent",operatorArgs:{indentRight:!1}},{keys:"g~",type:"operator",operator:"changeCase"},{keys:"gu",type:"operator",operator:"changeCase",operatorArgs:{toLower:!0},isEdit:!0},{keys:"gU",type:"operator",operator:"changeCase",operatorArgs:{toLower:!1},isEdit:!0},{keys:"n",type:"motion",motion:"findNext",motionArgs:{forward:!0,toJumplist:!0}},{keys:"N",type:"motion",motion:"findNext",motionArgs:{forward:!1,toJumplist:!0}},{keys:"x",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:!0},operatorMotionArgs:{visualLine:!1}},{keys:"X",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:!1},operatorMotionArgs:{visualLine:!0}},{keys:"D",type:"operatorMotion",operator:"delete",motion:"moveToEol",motionArgs:{inclusive:!0},context:"normal"},{keys:"D",type:"operator",operator:"delete",operatorArgs:{linewise:!0},context:"visual"},{keys:"Y",type:"operatorMotion",operator:"yank",motion:"expandToLine",motionArgs:{linewise:!0},context:"normal"},{keys:"Y",type:"operator",operator:"yank",operatorArgs:{linewise:!0},context:"visual"},{keys:"C",type:"operatorMotion",operator:"change",motion:"moveToEol",motionArgs:{inclusive:!0},context:"normal"},{keys:"C",type:"operator",operator:"change",operatorArgs:{linewise:!0},context:"visual"},{keys:"~",type:"operatorMotion",operator:"changeCase",motion:"moveByCharacters",motionArgs:{forward:!0},operatorArgs:{shouldMoveCursor:!0},context:"normal"},{keys:"~",type:"operator",operator:"changeCase",context:"visual"},{keys:"<C-w>",type:"operatorMotion",operator:"delete",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1},context:"insert"},{keys:"<C-i>",type:"action",action:"jumpListWalk",actionArgs:{forward:!0}},{keys:"<C-o>",type:"action",action:"jumpListWalk",actionArgs:{forward:!1}},{keys:"<C-e>",type:"action",action:"scroll",actionArgs:{forward:!0,linewise:!0}},{keys:"<C-y>",type:"action",action:"scroll",actionArgs:{forward:!1,linewise:!0}},{keys:"a",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"charAfter"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"eol"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"endOfSelectedArea"},context:"visual"},{keys:"i",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"inplace"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"firstNonBlank"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"startOfSelectedArea"},context:"visual"},{keys:"o",type:"action",action:"newLineAndEnterInsertMode",isEdit:!0,interlaceInsertRepeat:!0,actionArgs:{after:!0},context:"normal"},{keys:"O",type:"action",action:"newLineAndEnterInsertMode",isEdit:!0,interlaceInsertRepeat:!0,actionArgs:{after:!1},context:"normal"},{keys:"v",type:"action",action:"toggleVisualMode"},{keys:"V",type:"action",action:"toggleVisualMode",actionArgs:{linewise:!0}},{keys:"<C-v>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:!0}},{keys:"<C-q>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:!0}},{keys:"gv",type:"action",action:"reselectLastSelection"},{keys:"J",type:"action",action:"joinLines",isEdit:!0},{keys:"p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!0,isEdit:!0}},{keys:"P",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!1,isEdit:!0}},{keys:"r<character>",type:"action",action:"replace",isEdit:!0},{keys:"@<character>",type:"action",action:"replayMacro"},{keys:"q<character>",type:"action",action:"enterMacroRecordMode"},{keys:"R",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{replace:!0}},{keys:"u",type:"action",action:"undo",context:"normal"},{keys:"u",type:"operator",operator:"changeCase",operatorArgs:{toLower:!0},context:"visual",isEdit:!0},{keys:"U",type:"operator",operator:"changeCase",operatorArgs:{toLower:!1},context:"visual",isEdit:!0},{keys:"<C-r>",type:"action",action:"redo"},{keys:"m<character>",type:"action",action:"setMark"},{keys:'"<character>',type:"action",action:"setRegister"},{keys:"zz",type:"action",action:"scrollToCursor",actionArgs:{position:"center"}},{keys:"z.",type:"action",action:"scrollToCursor",actionArgs:{position:"center"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"zt",type:"action",action:"scrollToCursor",actionArgs:{position:"top"}},{keys:"z<CR>",type:"action",action:"scrollToCursor",actionArgs:{position:"top"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"z-",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"}},{keys:"zb",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:".",type:"action",action:"repeatLastEdit"},{keys:"<C-a>",type:"action",action:"incrementNumberToken",isEdit:!0,actionArgs:{increase:!0,backtrack:!1}},{keys:"<C-x>",type:"action",action:"incrementNumberToken",isEdit:!0,actionArgs:{increase:!1,backtrack:!1}},{keys:"<C-t>",type:"action",action:"indent",actionArgs:{indentRight:!0},context:"insert"},{keys:"<C-d>",type:"action",action:"indent",actionArgs:{indentRight:!1},context:"insert"},{keys:"a<character>",type:"motion",motion:"textObjectManipulation"},{keys:"i<character>",type:"motion",motion:"textObjectManipulation",motionArgs:{textObjectInner:!0}},{keys:"/",type:"search",searchArgs:{forward:!0,querySrc:"prompt",toJumplist:!0}},{keys:"?",type:"search",searchArgs:{forward:!1,querySrc:"prompt",toJumplist:!0}},{keys:"*",type:"search",searchArgs:{forward:!0,querySrc:"wordUnderCursor",wholeWordOnly:!0,toJumplist:!0}},{keys:"#",type:"search",searchArgs:{forward:!1,querySrc:"wordUnderCursor",wholeWordOnly:!0,toJumplist:!0}},{keys:"g*",type:"search",searchArgs:{forward:!0,querySrc:"wordUnderCursor",toJumplist:!0}},{keys:"g#",type:"search",searchArgs:{forward:!1,querySrc:"wordUnderCursor",toJumplist:!0}},{keys:":",type:"ex"}],defaultExCommandMap=[{name:"colorscheme",shortName:"colo"},{name:"map"},{name:"imap",shortName:"im"},{name:"nmap",shortName:"nm"},{name:"vmap",shortName:"vm"},{name:"unmap"},{name:"write",shortName:"w"},{name:"undo",shortName:"u"},{name:"redo",shortName:"red"},{name:"set",shortName:"se"},{name:"set",shortName:"se"},{name:"setlocal",shortName:"setl"},{name:"setglobal",shortName:"setg"},{name:"sort",shortName:"sor"},{name:"substitute",shortName:"s",possiblyAsync:!0},{name:"nohlsearch",shortName:"noh"},{name:"yank",shortName:"y"},{name:"delmarks",shortName:"delm"},{name:"registers",shortName:"reg",excludeFromCommandHistory:!0},{name:"global",shortName:"g"}],Pos=CodeMirror.Pos,Vim=function(){function enterVimMode(cm){cm.setOption("disableInput",!0),cm.setOption("showCursorWhenSelecting",!1),CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"}),cm.on("cursorActivity",onCursorActivity),maybeInitVimState(cm),CodeMirror.on(cm.getInputField(),"paste",getOnPasteFn(cm))}function leaveVimMode(cm){cm.setOption("disableInput",!1),cm.off("cursorActivity",onCursorActivity),CodeMirror.off(cm.getInputField(),"paste",getOnPasteFn(cm)),cm.state.vim=null}function detachVimMap(cm,next){this==CodeMirror.keyMap.vim&&CodeMirror.rmClass(cm.getWrapperElement(),"cm-fat-cursor"),next&&next.attach==attachVimMap||leaveVimMode(cm)}function attachVimMap(cm,prev){this==CodeMirror.keyMap.vim&&CodeMirror.addClass(cm.getWrapperElement(),"cm-fat-cursor"),prev&&prev.attach==attachVimMap||enterVimMode(cm)}function cmKey(key,cm){if(cm){if(this[key])return this[key];var vimKey=cmKeyToVimKey(key);if(!vimKey)return!1;var cmd=CodeMirror.Vim.findKey(cm,vimKey);return"function"==typeof cmd&&CodeMirror.signal(cm,"vim-keypress",vimKey),cmd}}function cmKeyToVimKey(key){if("'"==key.charAt(0))return key.charAt(1);var pieces=key.split(/-(?!$)/),lastPiece=pieces[pieces.length-1];if(1==pieces.length&&1==pieces[0].length)return!1;if(2==pieces.length&&"Shift"==pieces[0]&&1==lastPiece.length)return!1;for(var hasCharacter=!1,i=0;i<pieces.length;i++){var piece=pieces[i];piece in modifiers?pieces[i]=modifiers[piece]:hasCharacter=!0,piece in specialKeys&&(pieces[i]=specialKeys[piece])}return!!hasCharacter&&(isUpperCase(lastPiece)&&(pieces[pieces.length-1]=lastPiece.toLowerCase()),"<"+pieces.join("-")+">")}function getOnPasteFn(cm){var vim=cm.state.vim;return vim.onPasteFn||(vim.onPasteFn=function(){vim.insertMode||(cm.setCursor(offsetCursor(cm.getCursor(),0,1)),actions.enterInsertMode(cm,{},vim))}),vim.onPasteFn}function makeKeyRange(start,size){for(var keys=[],i=start;i<start+size;i++)keys.push(String.fromCharCode(i));return keys}function isLine(cm,line){return line>=cm.firstLine()&&line<=cm.lastLine()}function isLowerCase(k){return/^[a-z]$/.test(k)}function isMatchableSymbol(k){return-1!="()[]{}".indexOf(k)}function isNumber(k){return numberRegex.test(k)}function isUpperCase(k){return/^[A-Z]$/.test(k)}function isWhiteSpaceString(k){return/^\s*$/.test(k)}function inArray(val,arr){for(var i=0;i<arr.length;i++)if(arr[i]==val)return!0;return!1}function defineOption(name,defaultValue,type,aliases,callback){if(void 0===defaultValue&&!callback)throw Error("defaultValue is required unless callback is provided");if(type||(type="string"),options[name]={type:type,defaultValue:defaultValue,callback:callback},aliases)for(var i=0;i<aliases.length;i++)options[aliases[i]]=options[name];defaultValue&&setOption(name,defaultValue)}function setOption(name,value,cm,cfg){var option=options[name],scope=(cfg=cfg||{}).scope;if(!option)return new Error("Unknown option: "+name);if("boolean"==option.type){if(value&&!0!==value)return new Error("Invalid argument: "+name+"="+value);!1!==value&&(value=!0)}option.callback?("local"!==scope&&option.callback(value,void 0),"global"!==scope&&cm&&option.callback(value,cm)):("local"!==scope&&(option.value="boolean"==option.type?!!value:value),"global"!==scope&&cm&&(cm.state.vim.options[name]={value:value}))}function getOption(name,cm,cfg){var option=options[name],scope=(cfg=cfg||{}).scope;if(!option)return new Error("Unknown option: "+name);if(option.callback){var local=cm&&option.callback(void 0,cm);return"global"!==scope&&void 0!==local?local:"local"!==scope?option.callback():void 0}return((local="global"!==scope&&cm&&cm.state.vim.options[name])||"local"!==scope&&option||{}).value}function MacroModeState(){this.latestRegister=void 0,this.isPlaying=!1,this.isRecording=!1,this.replaySearchQueries=[],this.onRecordingDone=void 0,this.lastInsertModeChanges=createInsertModeChanges()}function maybeInitVimState(cm){return cm.state.vim||(cm.state.vim={inputState:new InputState,lastEditInputState:void 0,lastEditActionCommand:void 0,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:!1,insertModeRepeat:void 0,visualMode:!1,visualLine:!1,visualBlock:!1,lastSelection:null,lastPastedText:null,sel:{},options:{}}),cm.state.vim}function resetVimGlobalState(){for(var optionName in vimGlobalState={searchQuery:null,searchIsReversed:!1,lastSubstituteReplacePart:void 0,jumpList:createCircularJumpList(),macroModeState:new MacroModeState,lastCharacterSearch:{increment:0,forward:!0,selectedCharacter:""},registerController:new RegisterController({}),searchHistoryController:new HistoryController,exCommandHistoryController:new HistoryController},options){var option=options[optionName];option.value=option.defaultValue}}function InputState(){this.prefixRepeat=[],this.motionRepeat=[],this.operator=null,this.operatorArgs=null,this.motion=null,this.motionArgs=null,this.keyBuffer=[],this.registerName=null}function clearInputState(cm,reason){cm.state.vim.inputState=new InputState,CodeMirror.signal(cm,"vim-command-done",reason)}function Register(text,linewise,blockwise){this.clear(),this.keyBuffer=[text||""],this.insertModeChanges=[],this.searchQueries=[],this.linewise=!!linewise,this.blockwise=!!blockwise}function defineRegister(name,register){var registers=vimGlobalState.registerController.registers;if(!name||1!=name.length)throw Error("Register name must be 1 character");if(registers[name])throw Error("Register already defined "+name);registers[name]=register,validRegisters.push(name)}function RegisterController(registers){this.registers=registers,this.unnamedRegister=registers['"']=new Register,registers["."]=new Register,registers[":"]=new Register,registers["/"]=new Register}function HistoryController(){this.historyBuffer=[],this.iterator=0,this.initialPrefix=null}function defineMotion(name,fn){motions[name]=fn}function fillArray(val,times){for(var arr=[],i=0;i<times;i++)arr.push(val);return arr}function defineOperator(name,fn){operators[name]=fn}function defineAction(name,fn){actions[name]=fn}function clipCursorToContent(cm,cur,includeLineBreak){var line=Math.min(Math.max(cm.firstLine(),cur.line),cm.lastLine()),maxCh=lineLength(cm,line)-1;maxCh=includeLineBreak?maxCh+1:maxCh;var ch=Math.min(Math.max(0,cur.ch),maxCh);return Pos(line,ch)}function copyArgs(args){var ret={};for(var prop in args)args.hasOwnProperty(prop)&&(ret[prop]=args[prop]);return ret}function offsetCursor(cur,offsetLine,offsetCh){return"object"==typeof offsetLine&&(offsetCh=offsetLine.ch,offsetLine=offsetLine.line),Pos(cur.line+offsetLine,cur.ch+offsetCh)}function getOffset(anchor,head){return{line:head.line-anchor.line,ch:head.line-anchor.line}}function commandMatches(keys,keyMap,context,inputState){for(var match,partial=[],full=[],i=0;i<keyMap.length;i++){var command=keyMap[i];"insert"==context&&"insert"!=command.context||command.context&&command.context!=context||inputState.operator&&"action"==command.type||!(match=commandMatch(keys,command.keys))||("partial"==match&&partial.push(command),"full"==match&&full.push(command))}return{partial:partial.length&&partial,full:full.length&&full}}function commandMatch(pressed,mapped){if("<character>"==mapped.slice(-11)){var prefixLen=mapped.length-11,pressedPrefix=pressed.slice(0,prefixLen),mappedPrefix=mapped.slice(0,prefixLen);return pressedPrefix==mappedPrefix&&pressed.length>prefixLen?"full":0==mappedPrefix.indexOf(pressedPrefix)&&"partial"}return pressed==mapped?"full":0==mapped.indexOf(pressed)&&"partial"}function lastChar(keys){var match=/^.*(<[^>]+>)$/.exec(keys),selectedCharacter=match?match[1]:keys.slice(-1);if(selectedCharacter.length>1)switch(selectedCharacter){case"<CR>":selectedCharacter="\n";break;case"<Space>":selectedCharacter=" ";break;default:selectedCharacter=""}return selectedCharacter}function repeatFn(cm,fn,repeat){return function(){for(var i=0;i<repeat;i++)fn(cm)}}function copyCursor(cur){return Pos(cur.line,cur.ch)}function cursorEqual(cur1,cur2){return cur1.ch==cur2.ch&&cur1.line==cur2.line}function cursorIsBefore(cur1,cur2){return cur1.line<cur2.line||cur1.line==cur2.line&&cur1.ch<cur2.ch}function cursorMin(cur1,cur2){return arguments.length>2&&(cur2=cursorMin.apply(void 0,Array.prototype.slice.call(arguments,1))),cursorIsBefore(cur1,cur2)?cur1:cur2}function cursorMax(cur1,cur2){return arguments.length>2&&(cur2=cursorMax.apply(void 0,Array.prototype.slice.call(arguments,1))),cursorIsBefore(cur1,cur2)?cur2:cur1}function cursorIsBetween(cur1,cur2,cur3){var cur1before2=cursorIsBefore(cur1,cur2),cur2before3=cursorIsBefore(cur2,cur3);return cur1before2&&cur2before3}function lineLength(cm,lineNum){return cm.getLine(lineNum).length}function trim(s){return s.trim?s.trim():s.replace(/^\s+|\s+$/g,"")}function escapeRegex(s){return s.replace(/([.?*+$\[\]\/\\(){}|\-])/g,"\\$1")}function extendLineToColumn(cm,lineNum,column){var endCh=lineLength(cm,lineNum),spaces=new Array(column-endCh+1).join(" ");cm.setCursor(Pos(lineNum,endCh)),cm.replaceRange(spaces,cm.getCursor())}function selectBlock(cm,selectionEnd){var selections=[],ranges=cm.listSelections(),head=copyCursor(cm.clipPos(selectionEnd)),isClipped=!cursorEqual(selectionEnd,head),primIndex=getIndex(ranges,cm.getCursor("head")),wasClipped=cursorEqual(ranges[primIndex].head,ranges[primIndex].anchor),max=ranges.length-1,index=max-primIndex>primIndex?max:0,base=ranges[index].anchor,firstLine=Math.min(base.line,head.line),lastLine=Math.max(base.line,head.line),baseCh=base.ch,headCh=head.ch,dir=ranges[index].head.ch-baseCh,newDir=headCh-baseCh;dir>0&&newDir<=0?(baseCh++,isClipped||headCh--):dir<0&&newDir>=0?(baseCh--,wasClipped||headCh++):dir<0&&-1==newDir&&(baseCh--,headCh++);for(var line=firstLine;line<=lastLine;line++){var range={anchor:new Pos(line,baseCh),head:new Pos(line,headCh)};selections.push(range)}return cm.setSelections(selections),selectionEnd.ch=headCh,base.ch=baseCh,base}function selectForInsert(cm,head,height){for(var sel=[],i=0;i<height;i++){var lineHead=offsetCursor(head,i,0);sel.push({anchor:lineHead,head:lineHead})}cm.setSelections(sel,0)}function getIndex(ranges,cursor,end){for(var i=0;i<ranges.length;i++){var atAnchor="head"!=end&&cursorEqual(ranges[i].anchor,cursor),atHead="anchor"!=end&&cursorEqual(ranges[i].head,cursor);if(atAnchor||atHead)return i}return-1}function getSelectedAreaRange(cm,vim){var lastSelection=vim.lastSelection,getCurrentSelectedAreaRange=function(){var selections=cm.listSelections(),start=selections[0],end=selections[selections.length-1];return[cursorIsBefore(start.anchor,start.head)?start.anchor:start.head,cursorIsBefore(end.anchor,end.head)?end.head:end.anchor]},getLastSelectedAreaRange=function(){var selectionStart=cm.getCursor(),selectionEnd=cm.getCursor(),block=lastSelection.visualBlock;if(block){var width=block.width,height=block.height;selectionEnd=Pos(selectionStart.line+height,selectionStart.ch+width);for(var selections=[],i=selectionStart.line;i<selectionEnd.line;i++){var range={anchor:Pos(i,selectionStart.ch),head:Pos(i,selectionEnd.ch)};selections.push(range)}cm.setSelections(selections)}else{var start=lastSelection.anchorMark.find(),end=lastSelection.headMark.find(),line=end.line-start.line,ch=end.ch-start.ch;selectionEnd={line:selectionEnd.line+line,ch:line?selectionEnd.ch:ch+selectionEnd.ch},lastSelection.visualLine&&(selectionStart=Pos(selectionStart.line,0),selectionEnd=Pos(selectionEnd.line,lineLength(cm,selectionEnd.line))),cm.setSelection(selectionStart,selectionEnd)}return[selectionStart,selectionEnd]};return vim.visualMode?getCurrentSelectedAreaRange():getLastSelectedAreaRange()}function updateLastSelection(cm,vim){var anchor=vim.sel.anchor,head=vim.sel.head;vim.lastPastedText&&(head=cm.posFromIndex(cm.indexFromPos(anchor)+vim.lastPastedText.length),vim.lastPastedText=null),vim.lastSelection={anchorMark:cm.setBookmark(anchor),headMark:cm.setBookmark(head),anchor:copyCursor(anchor),head:copyCursor(head),visualMode:vim.visualMode,visualLine:vim.visualLine,visualBlock:vim.visualBlock}}function expandSelection(cm,start,end){var tmp,sel=cm.state.vim.sel,head=sel.head,anchor=sel.anchor;return cursorIsBefore(end,start)&&(tmp=end,end=start,start=tmp),cursorIsBefore(head,anchor)?(head=cursorMin(start,head),anchor=cursorMax(anchor,end)):(anchor=cursorMin(start,anchor),-1==(head=offsetCursor(head=cursorMax(head,end),0,-1)).ch&&head.line!=cm.firstLine()&&(head=Pos(head.line-1,lineLength(cm,head.line-1)))),[anchor,head]}function updateCmSelection(cm,sel,mode){var vim=cm.state.vim,cmSel=makeCmSelection(cm,sel=sel||vim.sel,mode=mode||vim.visualLine?"line":vim.visualBlock?"block":"char");cm.setSelections(cmSel.ranges,cmSel.primary),updateFakeCursor(cm)}function makeCmSelection(cm,sel,mode,exclusive){var head=copyCursor(sel.head),anchor=copyCursor(sel.anchor);if("char"==mode){var headOffset=exclusive||cursorIsBefore(sel.head,sel.anchor)?0:1,anchorOffset=cursorIsBefore(sel.head,sel.anchor)?1:0;return head=offsetCursor(sel.head,0,headOffset),{ranges:[{anchor:anchor=offsetCursor(sel.anchor,0,anchorOffset),head:head}],primary:0}}if("line"==mode){if(cursorIsBefore(sel.head,sel.anchor))head.ch=0,anchor.ch=lineLength(cm,anchor.line);else{anchor.ch=0;var lastLine=cm.lastLine();head.line>lastLine&&(head.line=lastLine),head.ch=lineLength(cm,head.line)}return{ranges:[{anchor:anchor,head:head}],primary:0}}if("block"==mode){for(var top=Math.min(anchor.line,head.line),left=Math.min(anchor.ch,head.ch),bottom=Math.max(anchor.line,head.line),right=Math.max(anchor.ch,head.ch)+1,height=bottom-top+1,primary=head.line==top?0:height-1,ranges=[],i=0;i<height;i++)ranges.push({anchor:Pos(top+i,left),head:Pos(top+i,right)});return{ranges:ranges,primary:primary}}}function getHead(cm){var cur=cm.getCursor("head");return 1==cm.getSelection().length&&(cur=cursorMin(cur,cm.getCursor("anchor"))),cur}function exitVisualMode(cm,moveHead){var vim=cm.state.vim;!1!==moveHead&&cm.setCursor(clipCursorToContent(cm,vim.sel.head)),updateLastSelection(cm,vim),vim.visualMode=!1,vim.visualLine=!1,vim.visualBlock=!1,CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"}),vim.fakeCursor&&vim.fakeCursor.clear()}function clipToLine(cm,curStart,curEnd){var selection=cm.getRange(curStart,curEnd);if(/\n\s*$/.test(selection)){var lines=selection.split("\n");lines.pop();for(var line=lines.pop();lines.length>0&&line&&isWhiteSpaceString(line);line=lines.pop())curEnd.line--,curEnd.ch=0;line?(curEnd.line--,curEnd.ch=lineLength(cm,curEnd.line)):curEnd.ch=0}}function expandSelectionToLine(_cm,curStart,curEnd){curStart.ch=0,curEnd.ch=0,curEnd.line++}function findFirstNonWhiteSpaceCharacter(text){if(!text)return 0;var firstNonWS=text.search(/\S/);return-1==firstNonWS?text.length:firstNonWS}function expandWordUnderCursor(cm,inclusive,_forward,bigWord,noSymbol){for(var cur=getHead(cm),line=cm.getLine(cur.line),idx=cur.ch,test=noSymbol?wordCharTest[0]:bigWordCharTest[0];!test(line.charAt(idx));)if(++idx>=line.length)return null;bigWord?test=bigWordCharTest[0]:(test=wordCharTest[0])(line.charAt(idx))||(test=wordCharTest[1]);for(var end=idx,start=idx;test(line.charAt(end))&&end<line.length;)end++;for(;test(line.charAt(start))&&start>=0;)start--;if(start++,inclusive){for(var wordEnd=end;/\s/.test(line.charAt(end))&&end<line.length;)end++;if(wordEnd==end){for(var wordStart=start;/\s/.test(line.charAt(start-1))&&start>0;)start--;start||(start=wordStart)}}return{start:Pos(cur.line,start),end:Pos(cur.line,end)}}function recordJumpPosition(cm,oldCur,newCur){cursorEqual(oldCur,newCur)||vimGlobalState.jumpList.add(cm,oldCur,newCur)}function recordLastCharacterSearch(increment,args){vimGlobalState.lastCharacterSearch.increment=increment,vimGlobalState.lastCharacterSearch.forward=args.forward,vimGlobalState.lastCharacterSearch.selectedCharacter=args.selectedCharacter}function findSymbol(cm,repeat,forward,symb){var cur=copyCursor(cm.getCursor()),increment=forward?1:-1,endLine=forward?cm.lineCount():-1,curCh=cur.ch,line=cur.line,lineText=cm.getLine(line),state={lineText:lineText,nextCh:lineText.charAt(curCh),lastCh:null,index:curCh,symb:symb,reverseSymb:(forward?{")":"(","}":"{"}:{"(":")","{":"}"})[symb],forward:forward,depth:0,curMoveThrough:!1},mode=symbolToMode[symb];if(!mode)return cur;var init=findSymbolModes[mode].init,isComplete=findSymbolModes[mode].isComplete;for(init&&init(state);line!==endLine&&repeat;){if(state.index+=increment,state.nextCh=state.lineText.charAt(state.index),!state.nextCh){if(line+=increment,state.lineText=cm.getLine(line)||"",increment>0)state.index=0;else{var lineLen=state.lineText.length;state.index=lineLen>0?lineLen-1:0}state.nextCh=state.lineText.charAt(state.index)}isComplete(state)&&(cur.line=line,cur.ch=state.index,repeat--)}return state.nextCh||state.curMoveThrough?Pos(line,state.index):cur}function findWord(cm,cur,forward,bigWord,emptyLineIsWord){var lineNum=cur.line,pos=cur.ch,line=cm.getLine(lineNum),dir=forward?1:-1,charTests=bigWord?bigWordCharTest:wordCharTest;if(emptyLineIsWord&&""==line){if(lineNum+=dir,line=cm.getLine(lineNum),!isLine(cm,lineNum))return null;pos=forward?0:line.length}for(;;){if(emptyLineIsWord&&""==line)return{from:0,to:0,line:lineNum};for(var stop=dir>0?line.length:-1,wordStart=stop,wordEnd=stop;pos!=stop;){for(var foundWord=!1,i=0;i<charTests.length&&!foundWord;++i)if(charTests[i](line.charAt(pos))){for(wordStart=pos;pos!=stop&&charTests[i](line.charAt(pos));)pos+=dir;if(foundWord=wordStart!=(wordEnd=pos),wordStart==cur.ch&&lineNum==cur.line&&wordEnd==wordStart+dir)continue;return{from:Math.min(wordStart,wordEnd+1),to:Math.max(wordStart,wordEnd),line:lineNum}}foundWord||(pos+=dir)}if(!isLine(cm,lineNum+=dir))return null;line=cm.getLine(lineNum),pos=dir>0?0:line.length}}function moveToWord(cm,cur,repeat,forward,wordEnd,bigWord){var curStart=copyCursor(cur),words=[];(forward&&!wordEnd||!forward&&wordEnd)&&repeat++;for(var emptyLineIsWord=!(forward&&wordEnd),i=0;i<repeat;i++){var word=findWord(cm,cur,forward,bigWord,emptyLineIsWord);if(!word){var eodCh=lineLength(cm,cm.lastLine());words.push(forward?{line:cm.lastLine(),from:eodCh,to:eodCh}:{line:0,from:0,to:0});break}words.push(word),cur=Pos(word.line,forward?word.to-1:word.from)}var shortCircuit=words.length!=repeat,firstWord=words[0],lastWord=words.pop();return forward&&!wordEnd?(shortCircuit||firstWord.from==curStart.ch&&firstWord.line==curStart.line||(lastWord=words.pop()),Pos(lastWord.line,lastWord.from)):forward&&wordEnd?Pos(lastWord.line,lastWord.to-1):!forward&&wordEnd?(shortCircuit||firstWord.to==curStart.ch&&firstWord.line==curStart.line||(lastWord=words.pop()),Pos(lastWord.line,lastWord.to)):Pos(lastWord.line,lastWord.from)}function moveToCharacter(cm,repeat,forward,character){for(var idx,cur=cm.getCursor(),start=cur.ch,i=0;i<repeat;i++){if(-1==(idx=charIdxInLine(start,cm.getLine(cur.line),character,forward,!0)))return null;start=idx}return Pos(cm.getCursor().line,idx)}function moveToColumn(cm,repeat){var line=cm.getCursor().line;return clipCursorToContent(cm,Pos(line,repeat-1))}function updateMark(cm,vim,markName,pos){inArray(markName,validMarks)&&(vim.marks[markName]&&vim.marks[markName].clear(),vim.marks[markName]=cm.setBookmark(pos))}function charIdxInLine(start,line,character,forward,includeChar){var idx;return forward?-1==(idx=line.indexOf(character,start+1))||includeChar||(idx-=1):-1==(idx=line.lastIndexOf(character,start-1))||includeChar||(idx+=1),idx}function findParagraph(cm,head,repeat,dir,inclusive){function isEmpty(i){return!cm.getLine(i)}function isBoundary(i,dir,any){return any?isEmpty(i)!=isEmpty(i+dir):!isEmpty(i)&&isEmpty(i+dir)}var end,line=head.line,min=cm.firstLine(),max=cm.lastLine(),i=line;if(dir){for(;min<=i&&i<=max&&repeat>0;)isBoundary(i,dir)&&repeat--,i+=dir;return new Pos(i,0)}var vim=cm.state.vim;if(vim.visualLine&&isBoundary(line,1,!0)){var anchor=vim.sel.anchor;isBoundary(anchor.line,-1,!0)&&(inclusive&&anchor.line==line||(line+=1))}var startState=isEmpty(line);for(i=line;i<=max&&repeat;i++)isBoundary(i,1,!0)&&(inclusive&&isEmpty(i)==startState||repeat--);for(end=new Pos(i,0),i>max&&!startState?startState=!0:inclusive=!1,i=line;i>min&&(inclusive&&isEmpty(i)!=startState&&i!=line||!isBoundary(i,-1,!0));i--);return{start:new Pos(i,0),end:end}}function selectCompanionObject(cm,head,symb,inclusive){var start,end,cur=head,bracketRegexp={"(":/[()]/,")":/[()]/,"[":/[[\]]/,"]":/[[\]]/,"{":/[{}]/,"}":/[{}]/}[symb],openSym={"(":"(",")":"(","[":"[","]":"[","{":"{","}":"{"}[symb],offset=cm.getLine(cur.line).charAt(cur.ch)===openSym?1:0;if(start=cm.scanForBracket(Pos(cur.line,cur.ch+offset),-1,null,{bracketRegex:bracketRegexp}),end=cm.scanForBracket(Pos(cur.line,cur.ch+offset),1,null,{bracketRegex:bracketRegexp}),!start||!end)return{start:cur,end:cur};if(start=start.pos,end=end.pos,start.line==end.line&&start.ch>end.ch||start.line>end.line){var tmp=start;start=end,end=tmp}return inclusive?end.ch+=1:start.ch+=1,{start:start,end:end}}function findBeginningAndEnd(cm,head,symb,inclusive){var start,end,i,len,cur=copyCursor(head),chars=cm.getLine(cur.line).split(""),firstIndex=chars.indexOf(symb);if(cur.ch<firstIndex?cur.ch=firstIndex:firstIndex<cur.ch&&chars[cur.ch]==symb&&(end=cur.ch,--cur.ch),chars[cur.ch]!=symb||end)for(i=cur.ch;i>-1&&!start;i--)chars[i]==symb&&(start=i+1);else start=cur.ch+1;if(start&&!end)for(i=start,len=chars.length;i<len&&!end;i++)chars[i]==symb&&(end=i);return start&&end?(inclusive&&(--start,++end),{start:Pos(cur.line,start),end:Pos(cur.line,end)}):{start:cur,end:cur}}function SearchState(){}function getSearchState(cm){var vim=cm.state.vim;return vim.searchState_||(vim.searchState_=new SearchState)}function dialog(cm,template,shortText,onClose,options){cm.openDialog?cm.openDialog(template,onClose,{bottom:!0,value:options.value,onKeyDown:options.onKeyDown,onKeyUp:options.onKeyUp,selectValueOnOpen:!1}):onClose(prompt(shortText,""))}function splitBySlash(argString){var slashes=findUnescapedSlashes(argString)||[];if(!slashes.length)return[];var tokens=[];if(0===slashes[0]){for(var i=0;i<slashes.length;i++)"number"==typeof slashes[i]&&tokens.push(argString.substring(slashes[i]+1,slashes[i+1]));return tokens}}function findUnescapedSlashes(str){for(var escapeNextChar=!1,slashes=[],i=0;i<str.length;i++){var c=str.charAt(i);escapeNextChar||"/"!=c||slashes.push(i),escapeNextChar=!escapeNextChar&&"\\"==c}return slashes}function translateRegex(str){for(var specials="|(){",unescape="}",escapeNextChar=!1,out=[],i=-1;i<str.length;i++){var c=str.charAt(i)||"",n=str.charAt(i+1)||"",specialComesNext=n&&-1!=specials.indexOf(n);escapeNextChar?("\\"===c&&specialComesNext||out.push(c),escapeNextChar=!1):"\\"===c?(escapeNextChar=!0,n&&-1!=unescape.indexOf(n)&&(specialComesNext=!0),specialComesNext&&"\\"!==n||out.push(c)):(out.push(c),specialComesNext&&"\\"!==n&&out.push("\\"))}return out.join("")}function translateRegexReplace(str){for(var escapeNextChar=!1,out=[],i=-1;i<str.length;i++){var c=str.charAt(i)||"",n=str.charAt(i+1)||"";charUnescapes[c+n]?(out.push(charUnescapes[c+n]),i++):escapeNextChar?(out.push(c),escapeNextChar=!1):"\\"===c?(escapeNextChar=!0,isNumber(n)||"$"===n?out.push("$"):"/"!==n&&"\\"!==n&&out.push("\\")):("$"===c&&out.push("$"),out.push(c),"/"===n&&out.push("\\"))}return out.join("")}function unescapeRegexReplace(str){for(var stream=new CodeMirror.StringStream(str),output=[];!stream.eol();){for(;stream.peek()&&"\\"!=stream.peek();)output.push(stream.next());var matched=!1;for(var matcher in unescapes)if(stream.match(matcher,!0)){matched=!0,output.push(unescapes[matcher]);break}matched||output.push(stream.next())}return output.join("")}function parseQuery(query,ignoreCase,smartCase){if(vimGlobalState.registerController.getRegister("/").setText(query),query instanceof RegExp)return query;var regexPart,forceIgnoreCase,slashes=findUnescapedSlashes(query);slashes.length?(regexPart=query.substring(0,slashes[0]),forceIgnoreCase=-1!=query.substring(slashes[0]).indexOf("i")):regexPart=query;return regexPart?(getOption("pcre")||(regexPart=translateRegex(regexPart)),smartCase&&(ignoreCase=/^[^A-Z]*$/.test(regexPart)),new RegExp(regexPart,ignoreCase||forceIgnoreCase?"i":void 0)):null}function showConfirm(cm,text){cm.openNotification?cm.openNotification('<span style="color: red">'+text+"</span>",{bottom:!0,duration:5e3}):alert(text)}function makePrompt(prefix,desc){var raw='<span style="font-family: monospace; white-space: pre">'+(prefix||"")+'<input type="text"></span>';return desc&&(raw+=' <span style="color: #888">'+desc+"</span>"),raw}function showPrompt(cm,options){var shortText=(options.prefix||"")+" "+(options.desc||"");dialog(cm,makePrompt(options.prefix,options.desc),shortText,options.onClose,options)}function regexEqual(r1,r2){if(r1 instanceof RegExp&&r2 instanceof RegExp){for(var props=["global","multiline","ignoreCase","source"],i=0;i<props.length;i++){var prop=props[i];if(r1[prop]!==r2[prop])return!1}return!0}return!1}function updateSearchQuery(cm,rawQuery,ignoreCase,smartCase){if(rawQuery){var state=getSearchState(cm),query=parseQuery(rawQuery,!!ignoreCase,!!smartCase);if(query)return highlightSearchMatches(cm,query),regexEqual(query,state.getQuery())?query:(state.setQuery(query),query)}}function searchOverlay(query){if("^"==query.source.charAt(0))var matchSol=!0;return{token:function(stream){if(!matchSol||stream.sol()){var match=stream.match(query,!1);if(match)return 0==match[0].length?(stream.next(),"searching"):stream.sol()||(stream.backUp(1),query.exec(stream.next()+match[0]))?(stream.match(query),"searching"):(stream.next(),null);for(;!stream.eol()&&(stream.next(),!stream.match(query,!1)););}else stream.skipToEnd()},query:query}}function highlightSearchMatches(cm,query){var searchState=getSearchState(cm),overlay=searchState.getOverlay();overlay&&query==overlay.query||(overlay&&cm.removeOverlay(overlay),overlay=searchOverlay(query),cm.addOverlay(overlay),cm.showMatchesOnScrollbar&&(searchState.getScrollbarAnnotate()&&searchState.getScrollbarAnnotate().clear(),searchState.setScrollbarAnnotate(cm.showMatchesOnScrollbar(query))),searchState.setOverlay(overlay))}function findNext(cm,prev,query,repeat){return void 0===repeat&&(repeat=1),cm.operation(function(){for(var pos=cm.getCursor(),cursor=cm.getSearchCursor(query,pos),i=0;i<repeat;i++){var found=cursor.find(prev);if(0==i&&found&&cursorEqual(cursor.from(),pos)&&(found=cursor.find(prev)),!found&&!(cursor=cm.getSearchCursor(query,prev?Pos(cm.lastLine()):Pos(cm.firstLine(),0))).find(prev))return}return cursor.from()})}function clearSearchHighlight(cm){var state=getSearchState(cm);cm.removeOverlay(getSearchState(cm).getOverlay()),state.setOverlay(null),state.getScrollbarAnnotate()&&(state.getScrollbarAnnotate().clear(),state.setScrollbarAnnotate(null))}function isInRange(pos,start,end){return"number"!=typeof pos&&(pos=pos.line),start instanceof Array?inArray(pos,start):end?pos>=start&&pos<=end:pos==start}function getUserVisibleLines(cm){var scrollInfo=cm.getScrollInfo(),occludeToleranceTop=6,occludeToleranceBottom=10,from=cm.coordsChar({left:0,top:occludeToleranceTop+scrollInfo.top},"local"),bottomY=scrollInfo.clientHeight-occludeToleranceBottom+scrollInfo.top,to=cm.coordsChar({left:0,top:bottomY},"local");return{top:from.line,bottom:to.line}}function getMarkPos(cm,vim,markName){if("'"==markName){var history=cm.doc.history.done,event=history[history.length-2];return event&&event.ranges&&event.ranges[0].head}var mark=vim.marks[markName];return mark&&mark.find()}function doReplace(cm,confirm,global,lineStart,lineEnd,searchCursor,query,replaceWith,callback){function replaceAll(){cm.operation(function(){for(;!done;)replace(),next();stop()})}function replace(){var newText=cm.getRange(searchCursor.from(),searchCursor.to()).replace(query,replaceWith);searchCursor.replace(newText)}function next(){for(;searchCursor.findNext()&&isInRange(searchCursor.from(),lineStart,lineEnd);)if(global||!lastPos||searchCursor.from().line!=lastPos.line)return cm.scrollIntoView(searchCursor.from(),30),cm.setSelection(searchCursor.from(),searchCursor.to()),lastPos=searchCursor.from(),void(done=!1);done=!0}function stop(close){if(close&&close(),cm.focus(),lastPos){cm.setCursor(lastPos);var vim=cm.state.vim;vim.exMode=!1,vim.lastHPos=vim.lastHSPos=lastPos.ch}callback&&callback()}function onPromptKeyDown(e,_value,close){switch(CodeMirror.e_stop(e),CodeMirror.keyName(e)){case"Y":replace(),next();break;case"N":next();break;case"A":var savedCallback=callback;callback=void 0,cm.operation(replaceAll),callback=savedCallback;break;case"L":replace();case"Q":case"Esc":case"Ctrl-C":case"Ctrl-[":stop(close)}return done&&stop(close),!0}cm.state.vim.exMode=!0;var done=!1,lastPos=searchCursor.from();if(next(),!done)return confirm?void showPrompt(cm,{prefix:"replace with <strong>"+replaceWith+"</strong> (y/n/a/q/l)",onKeyDown:onPromptKeyDown}):(replaceAll(),void(callback&&callback()));showConfirm(cm,"No matches for "+query.source)}function exitInsertMode(cm){var vim=cm.state.vim,macroModeState=vimGlobalState.macroModeState,insertModeChangeRegister=vimGlobalState.registerController.getRegister("."),isPlaying=macroModeState.isPlaying,lastChange=macroModeState.lastInsertModeChanges,text=[];if(!isPlaying){for(var selLength=lastChange.inVisualBlock?vim.lastSelection.visualBlock.height:1,changes=lastChange.changes,i=(text=[],0);i<changes.length;)text.push(changes[i]),changes[i]instanceof InsertModeKey?i++:i+=selLength;lastChange.changes=text,cm.off("change",onChange),CodeMirror.off(cm.getInputField(),"keydown",onKeyEventTargetKeyDown)}!isPlaying&&vim.insertModeRepeat>1&&(repeatLastEdit(cm,vim,vim.insertModeRepeat-1,!0),vim.lastEditInputState.repeatOverride=vim.insertModeRepeat),delete vim.insertModeRepeat,vim.insertMode=!1,cm.setCursor(cm.getCursor().line,cm.getCursor().ch-1),cm.setOption("keyMap","vim"),cm.setOption("disableInput",!0),cm.toggleOverwrite(!1),insertModeChangeRegister.setText(lastChange.changes.join("")),CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"}),macroModeState.isRecording&&logInsertModeChange(macroModeState)}function _mapCommand(command){defaultKeymap.unshift(command)}function mapCommand(keys,type,name,args,extra){var command={keys:keys,type:type};for(var key in command[type]=name,command[type+"Args"]=args,extra)command[key]=extra[key];_mapCommand(command)}function executeMacroRegister(cm,vim,macroModeState,registerName){var register=vimGlobalState.registerController.getRegister(registerName);if(":"==registerName)return register.keyBuffer[0]&&exCommandDispatcher.processCommand(cm,register.keyBuffer[0]),void(macroModeState.isPlaying=!1);var keyBuffer=register.keyBuffer,imc=0;macroModeState.isPlaying=!0,macroModeState.replaySearchQueries=register.searchQueries.slice(0);for(var i=0;i<keyBuffer.length;i++)for(var match,key,text=keyBuffer[i];text;)if(key=(match=/<\w+-.+?>|<\w+>|./.exec(text))[0],text=text.substring(match.index+key.length),CodeMirror.Vim.handleKey(cm,key,"macro"),vim.insertMode){var changes=register.insertModeChanges[imc++].changes;vimGlobalState.macroModeState.lastInsertModeChanges.changes=changes,repeatInsertModeChanges(cm,changes,1),exitInsertMode(cm)}macroModeState.isPlaying=!1}function logKey(macroModeState,key){if(!macroModeState.isPlaying){var registerName=macroModeState.latestRegister,register=vimGlobalState.registerController.getRegister(registerName);register&&register.pushText(key)}}function logInsertModeChange(macroModeState){if(!macroModeState.isPlaying){var registerName=macroModeState.latestRegister,register=vimGlobalState.registerController.getRegister(registerName);register&&register.pushInsertModeChanges&&register.pushInsertModeChanges(macroModeState.lastInsertModeChanges)}}function logSearchQuery(macroModeState,query){if(!macroModeState.isPlaying){var registerName=macroModeState.latestRegister,register=vimGlobalState.registerController.getRegister(registerName);register&&register.pushSearchQuery&&register.pushSearchQuery(query)}}function onChange(cm,changeObj){var macroModeState=vimGlobalState.macroModeState,lastChange=macroModeState.lastInsertModeChanges;if(!macroModeState.isPlaying)for(;changeObj;){if(lastChange.expectCursorActivityForChange=!0,"+input"==changeObj.origin||"paste"==changeObj.origin||void 0===changeObj.origin){var text=changeObj.text.join("\n");lastChange.maybeReset&&(lastChange.changes=[],lastChange.maybeReset=!1),cm.state.overwrite&&!/\n/.test(text)?lastChange.changes.push([text]):lastChange.changes.push(text)}changeObj=changeObj.next}}function onCursorActivity(cm){var vim=cm.state.vim;if(vim.insertMode){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isPlaying)return;var lastChange=macroModeState.lastInsertModeChanges;lastChange.expectCursorActivityForChange?lastChange.expectCursorActivityForChange=!1:lastChange.maybeReset=!0}else cm.curOp.isVimOp||handleExternalSelection(cm,vim);vim.visualMode&&updateFakeCursor(cm)}function updateFakeCursor(cm){var vim=cm.state.vim,from=clipCursorToContent(cm,copyCursor(vim.sel.head)),to=offsetCursor(from,0,1);vim.fakeCursor&&vim.fakeCursor.clear(),vim.fakeCursor=cm.markText(from,to,{className:"cm-animate-fat-cursor"})}function handleExternalSelection(cm,vim){var anchor=cm.getCursor("anchor"),head=cm.getCursor("head");if(vim.visualMode&&!cm.somethingSelected()?exitVisualMode(cm,!1):vim.visualMode||vim.insertMode||!cm.somethingSelected()||(vim.visualMode=!0,vim.visualLine=!1,CodeMirror.signal(cm,"vim-mode-change",{mode:"visual"})),vim.visualMode){var headOffset=cursorIsBefore(head,anchor)?0:-1,anchorOffset=cursorIsBefore(head,anchor)?-1:0;head=offsetCursor(head,0,headOffset),anchor=offsetCursor(anchor,0,anchorOffset),vim.sel={anchor:anchor,head:head},updateMark(cm,vim,"<",cursorMin(head,anchor)),updateMark(cm,vim,">",cursorMax(head,anchor))}else vim.insertMode||(vim.lastHPos=cm.getCursor().ch)}function InsertModeKey(keyName){this.keyName=keyName}function onKeyEventTargetKeyDown(e){function onKeyFound(){return lastChange.maybeReset&&(lastChange.changes=[],lastChange.maybeReset=!1),lastChange.changes.push(new InsertModeKey(keyName)),!0}var lastChange=vimGlobalState.macroModeState.lastInsertModeChanges,keyName=CodeMirror.keyName(e);keyName&&(-1==keyName.indexOf("Delete")&&-1==keyName.indexOf("Backspace")||CodeMirror.lookupKey(keyName,"vim-insert",onKeyFound))}function repeatLastEdit(cm,vim,repeat,repeatForInsert){function repeatCommand(){isAction?commandDispatcher.processAction(cm,vim,vim.lastEditActionCommand):commandDispatcher.evalInput(cm,vim)}function repeatInsert(repeat){if(macroModeState.lastInsertModeChanges.changes.length>0){repeat=vim.lastEditActionCommand?repeat:1;var changeObject=macroModeState.lastInsertModeChanges;repeatInsertModeChanges(cm,changeObject.changes,repeat)}}var macroModeState=vimGlobalState.macroModeState;macroModeState.isPlaying=!0;var isAction=!!vim.lastEditActionCommand,cachedInputState=vim.inputState;if(vim.inputState=vim.lastEditInputState,isAction&&vim.lastEditActionCommand.interlaceInsertRepeat)for(var i=0;i<repeat;i++)repeatCommand(),repeatInsert(1);else repeatForInsert||repeatCommand(),repeatInsert(repeat);vim.inputState=cachedInputState,vim.insertMode&&!repeatForInsert&&exitInsertMode(cm),macroModeState.isPlaying=!1}function repeatInsertModeChanges(cm,changes,repeat){function keyHandler(binding){return"string"==typeof binding?CodeMirror.commands[binding](cm):binding(cm),!0}var head=cm.getCursor("head"),inVisualBlock=vimGlobalState.macroModeState.lastInsertModeChanges.inVisualBlock;if(inVisualBlock){var lastSel=cm.state.vim.lastSelection,offset=getOffset(lastSel.anchor,lastSel.head);selectForInsert(cm,head,offset.line+1),repeat=cm.listSelections().length,cm.setCursor(head)}for(var i=0;i<repeat;i++){inVisualBlock&&cm.setCursor(offsetCursor(head,i,0));for(var j=0;j<changes.length;j++){var change=changes[j];if(change instanceof InsertModeKey)CodeMirror.lookupKey(change.keyName,"vim-insert",keyHandler);else if("string"==typeof change){var cur=cm.getCursor();cm.replaceRange(change,cur,cur)}else{var start=cm.getCursor(),end=offsetCursor(start,0,change[0].length);cm.replaceRange(change[0],start,end)}}}inVisualBlock&&cm.setCursor(offsetCursor(head,0,1))}CodeMirror.defineOption("vimMode",!1,function(cm,val,prev){val&&"vim"!=cm.getOption("keyMap")?cm.setOption("keyMap","vim"):!val&&prev!=CodeMirror.Init&&/^vim/.test(cm.getOption("keyMap"))&&cm.setOption("keyMap","default")});var modifiers={Shift:"S",Ctrl:"C",Alt:"A",Cmd:"D",Mod:"A"},specialKeys={Enter:"CR",Backspace:"BS",Delete:"Del",Insert:"Ins"},numberRegex=/[\d]/,wordCharTest=[CodeMirror.isWordChar,function(ch){return ch&&!CodeMirror.isWordChar(ch)&&!/\s/.test(ch)}],bigWordCharTest=[function(ch){return/\S/.test(ch)}],upperCaseAlphabet=makeKeyRange(65,26),lowerCaseAlphabet=makeKeyRange(97,26),numbers=makeKeyRange(48,10),validMarks=[].concat(upperCaseAlphabet,lowerCaseAlphabet,numbers,["<",">"]),validRegisters=[].concat(upperCaseAlphabet,lowerCaseAlphabet,numbers,["-",'"',".",":","/"]),options={};defineOption("filetype",void 0,"string",["ft"],function(name,cm){if(void 0!==cm){if(void 0===name)return"null"==(mode=cm.getOption("mode"))?"":mode;var mode=""==name?"null":name;cm.setOption("mode",mode)}});var vimGlobalState,lastInsertModeKeyTimer,createCircularJumpList=function(){function add(cm,oldCur,newCur){function useNextSlot(cursor){var next=++pointer%size,trashMark=buffer[next];trashMark&&trashMark.clear(),buffer[next]=cm.setBookmark(cursor)}var curMark=buffer[pointer%size];if(curMark){var markPos=curMark.find();markPos&&!cursorEqual(markPos,oldCur)&&useNextSlot(oldCur)}else useNextSlot(oldCur);useNextSlot(newCur),head=pointer,(tail=pointer-size+1)<0&&(tail=0)}function move(cm,offset){(pointer+=offset)>head?pointer=head:pointer<tail&&(pointer=tail);var mark=buffer[(size+pointer)%size];if(mark&&!mark.find()){var newCur,inc=offset>0?1:-1,oldCur=cm.getCursor();do{if((mark=buffer[(size+(pointer+=inc))%size])&&(newCur=mark.find())&&!cursorEqual(oldCur,newCur))break}while(pointer<head&&pointer>tail)}return mark}var size=100,pointer=-1,head=0,tail=0,buffer=new Array(size);return{cachedCursor:void 0,add:add,move:move}},createInsertModeChanges=function(c){return c?{changes:c.changes,expectCursorActivityForChange:c.expectCursorActivityForChange}:{changes:[],expectCursorActivityForChange:!1}};MacroModeState.prototype={exitMacroRecordMode:function(){var macroModeState=vimGlobalState.macroModeState;macroModeState.onRecordingDone&&macroModeState.onRecordingDone(),macroModeState.onRecordingDone=void 0,macroModeState.isRecording=!1},enterMacroRecordMode:function(cm,registerName){var register=vimGlobalState.registerController.getRegister(registerName);register&&(register.clear(),this.latestRegister=registerName,cm.openDialog&&(this.onRecordingDone=cm.openDialog("(recording)["+registerName+"]",null,{bottom:!0})),this.isRecording=!0)}};var vimApi={buildKeyMap:function(){},getRegisterController:function(){return vimGlobalState.registerController},resetVimGlobalState_:resetVimGlobalState,getVimGlobalState_:function(){return vimGlobalState},maybeInitVimState_:maybeInitVimState,suppressErrorLogging:!1,InsertModeKey:InsertModeKey,map:function(lhs,rhs,ctx){exCommandDispatcher.map(lhs,rhs,ctx)},unmap:function(lhs,ctx){exCommandDispatcher.unmap(lhs,ctx)},setOption:setOption,getOption:getOption,defineOption:defineOption,defineEx:function(name,prefix,func){if(prefix){if(0!==name.indexOf(prefix))throw new Error('(Vim.defineEx) "'+prefix+'" is not a prefix of "'+name+'", command not registered')}else prefix=name;exCommands[name]=func,exCommandDispatcher.commandMap_[prefix]={name:name,shortName:prefix,type:"api"}},handleKey:function(cm,key,origin){var command=this.findKey(cm,key,origin);if("function"==typeof command)return command()},findKey:function(cm,key,origin){function handleMacroRecording(){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isRecording){if("q"==key)return macroModeState.exitMacroRecordMode(),clearInputState(cm),!0;"mapping"!=origin&&logKey(macroModeState,key)}}function handleEsc(){if("<Esc>"==key)return clearInputState(cm),vim.visualMode?exitVisualMode(cm):vim.insertMode&&exitInsertMode(cm),!0}function doKeyToKey(keys){for(var match;keys;)match=/<\w+-.+?>|<\w+>|./.exec(keys),key=match[0],keys=keys.substring(match.index+key.length),CodeMirror.Vim.handleKey(cm,key,"mapping")}function handleKeyInsertMode(){if(handleEsc())return!0;for(var keys=vim.inputState.keyBuffer=vim.inputState.keyBuffer+key,keysAreChars=1==key.length,match=commandDispatcher.matchCommand(keys,defaultKeymap,vim.inputState,"insert");keys.length>1&&"full"!=match.type;){keys=vim.inputState.keyBuffer=keys.slice(1);var thisMatch=commandDispatcher.matchCommand(keys,defaultKeymap,vim.inputState,"insert");"none"!=thisMatch.type&&(match=thisMatch)}if("none"==match.type)return clearInputState(cm),!1;if("partial"==match.type)return lastInsertModeKeyTimer&&window.clearTimeout(lastInsertModeKeyTimer),lastInsertModeKeyTimer=window.setTimeout(function(){vim.insertMode&&vim.inputState.keyBuffer&&clearInputState(cm)},getOption("insertModeEscKeysTimeout")),!keysAreChars;if(lastInsertModeKeyTimer&&window.clearTimeout(lastInsertModeKeyTimer),keysAreChars){for(var selections=cm.listSelections(),i=0;i<selections.length;i++){var here=selections[i].head;cm.replaceRange("",offsetCursor(here,0,-(keys.length-1)),here,"+input")}vimGlobalState.macroModeState.lastInsertModeChanges.changes.pop()}return clearInputState(cm),match.command}function handleKeyNonInsertMode(){if(handleMacroRecording()||handleEsc())return!0;var keys=vim.inputState.keyBuffer=vim.inputState.keyBuffer+key;if(/^[1-9]\d*$/.test(keys))return!0;if(!(keysMatcher=/^(\d*)(.*)$/.exec(keys)))return clearInputState(cm),!1;var keysMatcher,context=vim.visualMode?"visual":"normal",match=commandDispatcher.matchCommand(keysMatcher[2]||keysMatcher[1],defaultKeymap,vim.inputState,context);return"none"==match.type?(clearInputState(cm),!1):"partial"==match.type||(vim.inputState.keyBuffer="",(keysMatcher=/^(\d*)(.*)$/.exec(keys))[1]&&"0"!=keysMatcher[1]&&vim.inputState.pushRepeatDigit(keysMatcher[1]),match.command)}var command,vim=maybeInitVimState(cm);return!1===(command=vim.insertMode?handleKeyInsertMode():handleKeyNonInsertMode())?void 0:!0===command?function(){return!0}:function(){return cm.operation(function(){cm.curOp.isVimOp=!0;try{"keyToKey"==command.type?doKeyToKey(command.toKeys):commandDispatcher.processCommand(cm,vim,command)}catch(e){throw cm.state.vim=void 0,maybeInitVimState(cm),CodeMirror.Vim.suppressErrorLogging||console.log(e),e}return!0})}},handleEx:function(cm,input){exCommandDispatcher.processCommand(cm,input)},defineMotion:defineMotion,defineAction:defineAction,defineOperator:defineOperator,mapCommand:mapCommand,_mapCommand:_mapCommand,defineRegister:defineRegister,exitVisualMode:exitVisualMode,exitInsertMode:exitInsertMode};InputState.prototype.pushRepeatDigit=function(n){this.operator?this.motionRepeat=this.motionRepeat.concat(n):this.prefixRepeat=this.prefixRepeat.concat(n)},InputState.prototype.getRepeat=function(){var repeat=0;return(this.prefixRepeat.length>0||this.motionRepeat.length>0)&&(repeat=1,this.prefixRepeat.length>0&&(repeat*=parseInt(this.prefixRepeat.join(""),10)),this.motionRepeat.length>0&&(repeat*=parseInt(this.motionRepeat.join(""),10))),repeat},Register.prototype={setText:function(text,linewise,blockwise){this.keyBuffer=[text||""],this.linewise=!!linewise,this.blockwise=!!blockwise},pushText:function(text,linewise){linewise&&(this.linewise||this.keyBuffer.push("\n"),this.linewise=!0),this.keyBuffer.push(text)},pushInsertModeChanges:function(changes){this.insertModeChanges.push(createInsertModeChanges(changes))},pushSearchQuery:function(query){this.searchQueries.push(query)},clear:function(){this.keyBuffer=[],this.insertModeChanges=[],this.searchQueries=[],this.linewise=!1},toString:function(){return this.keyBuffer.join("")}},RegisterController.prototype={pushText:function(registerName,operator,text,linewise,blockwise){linewise&&"\n"!==text.charAt(text.length-1)&&(text+="\n");var register=this.isValidRegister(registerName)?this.getRegister(registerName):null;if(register){isUpperCase(registerName)?register.pushText(text,linewise):register.setText(text,linewise,blockwise),this.unnamedRegister.setText(register.toString(),linewise)}else{switch(operator){case"yank":this.registers[0]=new Register(text,linewise,blockwise);break;case"delete":case"change":-1==text.indexOf("\n")?this.registers["-"]=new Register(text,linewise):(this.shiftNumericRegisters_(),this.registers[1]=new Register(text,linewise))}this.unnamedRegister.setText(text,linewise,blockwise)}},getRegister:function(name){return this.isValidRegister(name)?(name=name.toLowerCase(),this.registers[name]||(this.registers[name]=new Register),this.registers[name]):this.unnamedRegister},isValidRegister:function(name){return name&&inArray(name,validRegisters)},shiftNumericRegisters_:function(){for(var i=9;i>=2;i--)this.registers[i]=this.getRegister(""+(i-1))}},HistoryController.prototype={nextMatch:function(input,up){var historyBuffer=this.historyBuffer,dir=up?-1:1;null===this.initialPrefix&&(this.initialPrefix=input);for(var i=this.iterator+dir;up?i>=0:i<historyBuffer.length;i+=dir)for(var element=historyBuffer[i],j=0;j<=element.length;j++)if(this.initialPrefix==element.substring(0,j))return this.iterator=i,element;return i>=historyBuffer.length?(this.iterator=historyBuffer.length,this.initialPrefix):i<0?input:void 0},pushInput:function(input){var index=this.historyBuffer.indexOf(input);index>-1&&this.historyBuffer.splice(index,1),input.length&&this.historyBuffer.push(input)},reset:function(){this.initialPrefix=null,this.iterator=this.historyBuffer.length}};var commandDispatcher={matchCommand:function(keys,keyMap,inputState,context){var bestMatch,matches=commandMatches(keys,keyMap,context,inputState);if(!matches.full&&!matches.partial)return{type:"none"};if(!matches.full&&matches.partial)return{type:"partial"};for(var i=0;i<matches.full.length;i++){var match=matches.full[i];bestMatch||(bestMatch=match)}if("<character>"==bestMatch.keys.slice(-11)){var character=lastChar(keys);if(!character)return{type:"none"};inputState.selectedCharacter=character}return{type:"full",command:bestMatch}},processCommand:function(cm,vim,command){switch(vim.inputState.repeatOverride=command.repeatOverride,command.type){case"motion":this.processMotion(cm,vim,command);break;case"operator":this.processOperator(cm,vim,command);break;case"operatorMotion":this.processOperatorMotion(cm,vim,command);break;case"action":this.processAction(cm,vim,command);break;case"search":this.processSearch(cm,vim,command);break;case"ex":case"keyToEx":this.processEx(cm,vim,command)}},processMotion:function(cm,vim,command){vim.inputState.motion=command.motion,vim.inputState.motionArgs=copyArgs(command.motionArgs),this.evalInput(cm,vim)},processOperator:function(cm,vim,command){var inputState=vim.inputState;if(inputState.operator){if(inputState.operator==command.operator)return inputState.motion="expandToLine",inputState.motionArgs={linewise:!0},void this.evalInput(cm,vim);clearInputState(cm)}inputState.operator=command.operator,inputState.operatorArgs=copyArgs(command.operatorArgs),vim.visualMode&&this.evalInput(cm,vim)},processOperatorMotion:function(cm,vim,command){var visualMode=vim.visualMode,operatorMotionArgs=copyArgs(command.operatorMotionArgs);operatorMotionArgs&&visualMode&&operatorMotionArgs.visualLine&&(vim.visualLine=!0),this.processOperator(cm,vim,command),visualMode||this.processMotion(cm,vim,command)},processAction:function(cm,vim,command){var inputState=vim.inputState,repeat=inputState.getRepeat(),repeatIsExplicit=!!repeat,actionArgs=copyArgs(command.actionArgs)||{};inputState.selectedCharacter&&(actionArgs.selectedCharacter=inputState.selectedCharacter),command.operator&&this.processOperator(cm,vim,command),command.motion&&this.processMotion(cm,vim,command),(command.motion||command.operator)&&this.evalInput(cm,vim),actionArgs.repeat=repeat||1,actionArgs.repeatIsExplicit=repeatIsExplicit,actionArgs.registerName=inputState.registerName,clearInputState(cm),vim.lastMotion=null,command.isEdit&&this.recordLastEdit(vim,inputState,command),actions[command.action](cm,actionArgs,vim)},processSearch:function(cm,vim,command){function handleQuery(query,ignoreCase,smartCase){vimGlobalState.searchHistoryController.pushInput(query),vimGlobalState.searchHistoryController.reset();try{updateSearchQuery(cm,query,ignoreCase,smartCase)}catch(e){return showConfirm(cm,"Invalid regex: "+query),void clearInputState(cm)}commandDispatcher.processMotion(cm,vim,{type:"motion",motion:"findNext",motionArgs:{forward:!0,toJumplist:command.searchArgs.toJumplist}})}function onPromptClose(query){cm.scrollTo(originalScrollPos.left,originalScrollPos.top),handleQuery(query,!0,!0);var macroModeState=vimGlobalState.macroModeState;macroModeState.isRecording&&logSearchQuery(macroModeState,query)}function onPromptKeyUp(e,query,close){var up,offset,parsedQuery,keyName=CodeMirror.keyName(e);"Up"==keyName||"Down"==keyName?(up="Up"==keyName,offset=e.target?e.target.selectionEnd:0,close(query=vimGlobalState.searchHistoryController.nextMatch(query,up)||""),offset&&e.target&&(e.target.selectionEnd=e.target.selectionStart=Math.min(offset,e.target.value.length))):"Left"!=keyName&&"Right"!=keyName&&"Ctrl"!=keyName&&"Alt"!=keyName&&"Shift"!=keyName&&vimGlobalState.searchHistoryController.reset();try{parsedQuery=updateSearchQuery(cm,query,!0,!0)}catch(e){}parsedQuery?cm.scrollIntoView(findNext(cm,!forward,parsedQuery),30):(clearSearchHighlight(cm),cm.scrollTo(originalScrollPos.left,originalScrollPos.top))}function onPromptKeyDown(e,query,close){var keyName=CodeMirror.keyName(e);"Esc"==keyName||"Ctrl-C"==keyName||"Ctrl-["==keyName||"Backspace"==keyName&&""==query?(vimGlobalState.searchHistoryController.pushInput(query),vimGlobalState.searchHistoryController.reset(),updateSearchQuery(cm,originalQuery),clearSearchHighlight(cm),cm.scrollTo(originalScrollPos.left,originalScrollPos.top),CodeMirror.e_stop(e),clearInputState(cm),close(),cm.focus()):"Up"==keyName||"Down"==keyName?CodeMirror.e_stop(e):"Ctrl-U"==keyName&&(CodeMirror.e_stop(e),close(""))}if(cm.getSearchCursor){var forward=command.searchArgs.forward,wholeWordOnly=command.searchArgs.wholeWordOnly;getSearchState(cm).setReversed(!forward);var promptPrefix=forward?"/":"?",originalQuery=getSearchState(cm).getQuery(),originalScrollPos=cm.getScrollInfo();switch(command.searchArgs.querySrc){case"prompt":var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isPlaying)handleQuery(query=macroModeState.replaySearchQueries.shift(),!0,!1);else showPrompt(cm,{onClose:onPromptClose,prefix:promptPrefix,desc:searchPromptDesc,onKeyUp:onPromptKeyUp,onKeyDown:onPromptKeyDown});break;case"wordUnderCursor":var word=expandWordUnderCursor(cm,!1,!0,!1,!0),isKeyword=!0;if(word||(word=expandWordUnderCursor(cm,!1,!0,!1,!1),isKeyword=!1),!word)return;var query=cm.getLine(word.start.line).substring(word.start.ch,word.end.ch);query=isKeyword&&wholeWordOnly?"\\b"+query+"\\b":escapeRegex(query),vimGlobalState.jumpList.cachedCursor=cm.getCursor(),cm.setCursor(word.start),handleQuery(query,!0,!1)}}},processEx:function(cm,vim,command){function onPromptClose(input){vimGlobalState.exCommandHistoryController.pushInput(input),vimGlobalState.exCommandHistoryController.reset(),exCommandDispatcher.processCommand(cm,input)}function onPromptKeyDown(e,input,close){var up,offset,keyName=CodeMirror.keyName(e);("Esc"==keyName||"Ctrl-C"==keyName||"Ctrl-["==keyName||"Backspace"==keyName&&""==input)&&(vimGlobalState.exCommandHistoryController.pushInput(input),vimGlobalState.exCommandHistoryController.reset(),CodeMirror.e_stop(e),clearInputState(cm),close(),cm.focus()),"Up"==keyName||"Down"==keyName?(CodeMirror.e_stop(e),up="Up"==keyName,offset=e.target?e.target.selectionEnd:0,close(input=vimGlobalState.exCommandHistoryController.nextMatch(input,up)||""),offset&&e.target&&(e.target.selectionEnd=e.target.selectionStart=Math.min(offset,e.target.value.length))):"Ctrl-U"==keyName?(CodeMirror.e_stop(e),close("")):"Left"!=keyName&&"Right"!=keyName&&"Ctrl"!=keyName&&"Alt"!=keyName&&"Shift"!=keyName&&vimGlobalState.exCommandHistoryController.reset()}"keyToEx"==command.type?exCommandDispatcher.processCommand(cm,command.exArgs.input):vim.visualMode?showPrompt(cm,{onClose:onPromptClose,prefix:":",value:"'<,'>",onKeyDown:onPromptKeyDown}):showPrompt(cm,{onClose:onPromptClose,prefix:":",onKeyDown:onPromptKeyDown})},evalInput:function(cm,vim){var newHead,newAnchor,repeat,inputState=vim.inputState,motion=inputState.motion,motionArgs=inputState.motionArgs||{},operator=inputState.operator,operatorArgs=inputState.operatorArgs||{},registerName=inputState.registerName,sel=vim.sel,origHead=copyCursor(vim.visualMode?clipCursorToContent(cm,sel.head):cm.getCursor("head")),origAnchor=copyCursor(vim.visualMode?clipCursorToContent(cm,sel.anchor):cm.getCursor("anchor")),oldHead=copyCursor(origHead),oldAnchor=copyCursor(origAnchor);if(operator&&this.recordLastEdit(vim,inputState),(repeat=void 0!==inputState.repeatOverride?inputState.repeatOverride:inputState.getRepeat())>0&&motionArgs.explicitRepeat?motionArgs.repeatIsExplicit=!0:(motionArgs.noRepeat||!motionArgs.explicitRepeat&&0===repeat)&&(repeat=1,motionArgs.repeatIsExplicit=!1),inputState.selectedCharacter&&(motionArgs.selectedCharacter=operatorArgs.selectedCharacter=inputState.selectedCharacter),motionArgs.repeat=repeat,clearInputState(cm),motion){var motionResult=motions[motion](cm,origHead,motionArgs,vim);if(vim.lastMotion=motions[motion],!motionResult)return;if(motionArgs.toJumplist){var jumpList=vimGlobalState.jumpList,cachedCursor=jumpList.cachedCursor;cachedCursor?(recordJumpPosition(cm,cachedCursor,motionResult),delete jumpList.cachedCursor):recordJumpPosition(cm,origHead,motionResult)}motionResult instanceof Array?(newAnchor=motionResult[0],newHead=motionResult[1]):newHead=motionResult,newHead||(newHead=copyCursor(origHead)),vim.visualMode?(vim.visualBlock&&newHead.ch===1/0||(newHead=clipCursorToContent(cm,newHead,vim.visualBlock)),newAnchor&&(newAnchor=clipCursorToContent(cm,newAnchor,!0)),newAnchor=newAnchor||oldAnchor,sel.anchor=newAnchor,sel.head=newHead,updateCmSelection(cm),updateMark(cm,vim,"<",cursorIsBefore(newAnchor,newHead)?newAnchor:newHead),updateMark(cm,vim,">",cursorIsBefore(newAnchor,newHead)?newHead:newAnchor)):operator||(newHead=clipCursorToContent(cm,newHead),cm.setCursor(newHead.line,newHead.ch))}if(operator){if(operatorArgs.lastSel){newAnchor=oldAnchor;var lastSel=operatorArgs.lastSel,lineOffset=Math.abs(lastSel.head.line-lastSel.anchor.line),chOffset=Math.abs(lastSel.head.ch-lastSel.anchor.ch);newHead=lastSel.visualLine?Pos(oldAnchor.line+lineOffset,oldAnchor.ch):lastSel.visualBlock?Pos(oldAnchor.line+lineOffset,oldAnchor.ch+chOffset):lastSel.head.line==lastSel.anchor.line?Pos(oldAnchor.line,oldAnchor.ch+chOffset):Pos(oldAnchor.line+lineOffset,oldAnchor.ch),vim.visualMode=!0,vim.visualLine=lastSel.visualLine,vim.visualBlock=lastSel.visualBlock,sel=vim.sel={anchor:newAnchor,head:newHead},updateCmSelection(cm)}else vim.visualMode&&(operatorArgs.lastSel={anchor:copyCursor(sel.anchor),head:copyCursor(sel.head),visualBlock:vim.visualBlock,visualLine:vim.visualLine});var curStart,curEnd,linewise,mode,cmSel;if(vim.visualMode){if(curStart=cursorMin(sel.head,sel.anchor),curEnd=cursorMax(sel.head,sel.anchor),linewise=vim.visualLine||operatorArgs.linewise,cmSel=makeCmSelection(cm,{anchor:curStart,head:curEnd},mode=vim.visualBlock?"block":linewise?"line":"char"),linewise){var ranges=cmSel.ranges;if("block"==mode)for(var i=0;i<ranges.length;i++)ranges[i].head.ch=lineLength(cm,ranges[i].head.line);else"line"==mode&&(ranges[0].head=Pos(ranges[0].head.line+1,0))}}else{if(curStart=copyCursor(newAnchor||oldAnchor),cursorIsBefore(curEnd=copyCursor(newHead||oldHead),curStart)){var tmp=curStart;curStart=curEnd,curEnd=tmp}(linewise=motionArgs.linewise||operatorArgs.linewise)?expandSelectionToLine(cm,curStart,curEnd):motionArgs.forward&&clipToLine(cm,curStart,curEnd),cmSel=makeCmSelection(cm,{anchor:curStart,head:curEnd},mode="char",!motionArgs.inclusive||linewise)}cm.setSelections(cmSel.ranges,cmSel.primary),vim.lastMotion=null,operatorArgs.repeat=repeat,operatorArgs.registerName=registerName,operatorArgs.linewise=linewise;var operatorMoveTo=operators[operator](cm,operatorArgs,cmSel.ranges,oldAnchor,newHead);vim.visualMode&&exitVisualMode(cm,null!=operatorMoveTo),operatorMoveTo&&cm.setCursor(operatorMoveTo)}},recordLastEdit:function(vim,inputState,actionCommand){var macroModeState=vimGlobalState.macroModeState;macroModeState.isPlaying||(vim.lastEditInputState=inputState,vim.lastEditActionCommand=actionCommand,macroModeState.lastInsertModeChanges.changes=[],macroModeState.lastInsertModeChanges.expectCursorActivityForChange=!1)}},motions={moveToTopLine:function(cm,_head,motionArgs){var line=getUserVisibleLines(cm).top+motionArgs.repeat-1;return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},moveToMiddleLine:function(cm){var range=getUserVisibleLines(cm),line=Math.floor(.5*(range.top+range.bottom));return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},moveToBottomLine:function(cm,_head,motionArgs){var line=getUserVisibleLines(cm).bottom-motionArgs.repeat+1;return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},expandToLine:function(_cm,head,motionArgs){return Pos(head.line+motionArgs.repeat-1,1/0)},findNext:function(cm,_head,motionArgs){var state=getSearchState(cm),query=state.getQuery();if(query){var prev=!motionArgs.forward;return prev=state.isReversed()?!prev:prev,highlightSearchMatches(cm,query),findNext(cm,prev,query,motionArgs.repeat)}},goToMark:function(cm,_head,motionArgs,vim){var pos=getMarkPos(cm,vim,motionArgs.selectedCharacter);return pos?motionArgs.linewise?{line:pos.line,ch:findFirstNonWhiteSpaceCharacter(cm.getLine(pos.line))}:pos:null},moveToOtherHighlightedEnd:function(cm,_head,motionArgs,vim){if(vim.visualBlock&&motionArgs.sameLine){var sel=vim.sel;return[clipCursorToContent(cm,Pos(sel.anchor.line,sel.head.ch)),clipCursorToContent(cm,Pos(sel.head.line,sel.anchor.ch))]}return[vim.sel.head,vim.sel.anchor]},jumpToMark:function(cm,head,motionArgs,vim){for(var best=head,i=0;i<motionArgs.repeat;i++){var cursor=best;for(var key in vim.marks)if(isLowerCase(key)){var mark=vim.marks[key].find();if(!((motionArgs.forward?cursorIsBefore(mark,cursor):cursorIsBefore(cursor,mark))||motionArgs.linewise&&mark.line==cursor.line)){var equal=cursorEqual(cursor,best),between=motionArgs.forward?cursorIsBetween(cursor,mark,best):cursorIsBetween(best,mark,cursor);(equal||between)&&(best=mark)}}}return motionArgs.linewise&&(best=Pos(best.line,findFirstNonWhiteSpaceCharacter(cm.getLine(best.line)))),best},moveByCharacters:function(_cm,head,motionArgs){var cur=head,repeat=motionArgs.repeat,ch=motionArgs.forward?cur.ch+repeat:cur.ch-repeat;return Pos(cur.line,ch)},moveByLines:function(cm,head,motionArgs,vim){var cur=head,endCh=cur.ch;switch(vim.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:endCh=vim.lastHPos;break;default:vim.lastHPos=endCh}var repeat=motionArgs.repeat+(motionArgs.repeatOffset||0),line=motionArgs.forward?cur.line+repeat:cur.line-repeat,first=cm.firstLine(),last=cm.lastLine();return line<first&&cur.line==first?this.moveToStartOfLine(cm,head,motionArgs,vim):line>last&&cur.line==last?this.moveToEol(cm,head,motionArgs,vim):(motionArgs.toFirstChar&&(endCh=findFirstNonWhiteSpaceCharacter(cm.getLine(line)),vim.lastHPos=endCh),vim.lastHSPos=cm.charCoords(Pos(line,endCh),"div").left,Pos(line,endCh))},moveByDisplayLines:function(cm,head,motionArgs,vim){var cur=head;switch(vim.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:vim.lastHSPos=cm.charCoords(cur,"div").left}var repeat=motionArgs.repeat;if((res=cm.findPosV(cur,motionArgs.forward?repeat:-repeat,"line",vim.lastHSPos)).hitSide)if(motionArgs.forward)var goalCoords={top:cm.charCoords(res,"div").top+8,left:vim.lastHSPos},res=cm.coordsChar(goalCoords,"div");else{var resCoords=cm.charCoords(Pos(cm.firstLine(),0),"div");resCoords.left=vim.lastHSPos,res=cm.coordsChar(resCoords,"div")}return vim.lastHPos=res.ch,res},moveByPage:function(cm,head,motionArgs){var curStart=head,repeat=motionArgs.repeat;return cm.findPosV(curStart,motionArgs.forward?repeat:-repeat,"page")},moveByParagraph:function(cm,head,motionArgs){var dir=motionArgs.forward?1:-1;return findParagraph(cm,head,motionArgs.repeat,dir)},moveByScroll:function(cm,head,motionArgs,vim){var scrollbox=cm.getScrollInfo(),curEnd=null,repeat=motionArgs.repeat;repeat||(repeat=scrollbox.clientHeight/(2*cm.defaultTextHeight()));var orig=cm.charCoords(head,"local");if(motionArgs.repeat=repeat,!(curEnd=motions.moveByDisplayLines(cm,head,motionArgs,vim)))return null;var dest=cm.charCoords(curEnd,"local");return cm.scrollTo(null,scrollbox.top+dest.top-orig.top),curEnd},moveByWords:function(cm,head,motionArgs){return moveToWord(cm,head,motionArgs.repeat,!!motionArgs.forward,!!motionArgs.wordEnd,!!motionArgs.bigWord)},moveTillCharacter:function(cm,_head,motionArgs){var curEnd=moveToCharacter(cm,motionArgs.repeat,motionArgs.forward,motionArgs.selectedCharacter),increment=motionArgs.forward?-1:1;return recordLastCharacterSearch(increment,motionArgs),curEnd?(curEnd.ch+=increment,curEnd):null},moveToCharacter:function(cm,head,motionArgs){var repeat=motionArgs.repeat;return recordLastCharacterSearch(0,motionArgs),moveToCharacter(cm,repeat,motionArgs.forward,motionArgs.selectedCharacter)||head},moveToSymbol:function(cm,head,motionArgs){return findSymbol(cm,motionArgs.repeat,motionArgs.forward,motionArgs.selectedCharacter)||head},moveToColumn:function(cm,head,motionArgs,vim){var repeat=motionArgs.repeat;return vim.lastHPos=repeat-1,vim.lastHSPos=cm.charCoords(head,"div").left,moveToColumn(cm,repeat)},moveToEol:function(cm,head,motionArgs,vim){var cur=head;vim.lastHPos=1/0;var retval=Pos(cur.line+motionArgs.repeat-1,1/0),end=cm.clipPos(retval);return end.ch--,vim.lastHSPos=cm.charCoords(end,"div").left,retval},moveToFirstNonWhiteSpaceCharacter:function(cm,head){var cursor=head;return Pos(cursor.line,findFirstNonWhiteSpaceCharacter(cm.getLine(cursor.line)))},moveToMatchedSymbol:function(cm,head){for(var symbol,cursor=head,line=cursor.line,ch=cursor.ch,lineText=cm.getLine(line);ch<lineText.length;ch++)if((symbol=lineText.charAt(ch))&&isMatchableSymbol(symbol)){var style=cm.getTokenTypeAt(Pos(line,ch+1));if("string"!==style&&"comment"!==style)break}return ch<lineText.length?cm.findMatchingBracket(Pos(line,ch)).to:cursor},moveToStartOfLine:function(_cm,head){return Pos(head.line,0)},moveToLineOrEdgeOfDocument:function(cm,_head,motionArgs){var lineNum=motionArgs.forward?cm.lastLine():cm.firstLine();return motionArgs.repeatIsExplicit&&(lineNum=motionArgs.repeat-cm.getOption("firstLineNumber")),Pos(lineNum,findFirstNonWhiteSpaceCharacter(cm.getLine(lineNum)))},textObjectManipulation:function(cm,head,motionArgs,vim){var mirroredPairs={"(":")",")":"(","{":"}","}":"{","[":"]","]":"["},selfPaired={"'":!0,'"':!0},character=motionArgs.selectedCharacter;"b"==character?character="(":"B"==character&&(character="{");var tmp,inclusive=!motionArgs.textObjectInner;if(mirroredPairs[character])tmp=selectCompanionObject(cm,head,character,inclusive);else if(selfPaired[character])tmp=findBeginningAndEnd(cm,head,character,inclusive);else if("W"===character)tmp=expandWordUnderCursor(cm,inclusive,!0,!0);else if("w"===character)tmp=expandWordUnderCursor(cm,inclusive,!0,!1);else{if("p"!==character)return null;if(tmp=findParagraph(cm,head,motionArgs.repeat,0,inclusive),motionArgs.linewise=!0,vim.visualMode)vim.visualLine||(vim.visualLine=!0);else{var operatorArgs=vim.inputState.operatorArgs;operatorArgs&&(operatorArgs.linewise=!0),tmp.end.line--}}return cm.state.vim.visualMode?expandSelection(cm,tmp.start,tmp.end):[tmp.start,tmp.end]},repeatLastCharacterSearch:function(cm,head,motionArgs){var lastSearch=vimGlobalState.lastCharacterSearch,repeat=motionArgs.repeat,forward=motionArgs.forward===lastSearch.forward,increment=(lastSearch.increment?1:0)*(forward?-1:1);cm.moveH(-increment,"char"),motionArgs.inclusive=!!forward;var curEnd=moveToCharacter(cm,repeat,forward,lastSearch.selectedCharacter);return curEnd?(curEnd.ch+=increment,curEnd):(cm.moveH(increment,"char"),head)}},operators={change:function(cm,args,ranges){var finalHead,text,vim=cm.state.vim;if(vimGlobalState.macroModeState.lastInsertModeChanges.inVisualBlock=vim.visualBlock,vim.visualMode){text=cm.getSelection();var replacement=fillArray("",ranges.length);cm.replaceSelections(replacement),finalHead=cursorMin(ranges[0].head,ranges[0].anchor)}else{var anchor=ranges[0].anchor,head=ranges[0].head;text=cm.getRange(anchor,head);var lastState=vim.lastEditInputState||{};if("moveByWords"==lastState.motion&&!isWhiteSpaceString(text)){var match=/\s+$/.exec(text);match&&lastState.motionArgs&&lastState.motionArgs.forward&&(head=offsetCursor(head,0,-match[0].length),text=text.slice(0,-match[0].length))}var prevLineEnd=new Pos(anchor.line-1,Number.MAX_VALUE),wasLastLine=cm.firstLine()==cm.lastLine();head.line>cm.lastLine()&&args.linewise&&!wasLastLine?cm.replaceRange("",prevLineEnd,head):cm.replaceRange("",anchor,head),args.linewise&&(wasLastLine||(cm.setCursor(prevLineEnd),CodeMirror.commands.newlineAndIndent(cm)),anchor.ch=Number.MAX_VALUE),finalHead=anchor}vimGlobalState.registerController.pushText(args.registerName,"change",text,args.linewise,ranges.length>1),actions.enterInsertMode(cm,{head:finalHead},cm.state.vim)},delete:function(cm,args,ranges){var finalHead,text,vim=cm.state.vim;if(vim.visualBlock){text=cm.getSelection();var replacement=fillArray("",ranges.length);cm.replaceSelections(replacement),finalHead=ranges[0].anchor}else{var anchor=ranges[0].anchor,head=ranges[0].head;args.linewise&&head.line!=cm.firstLine()&&anchor.line==cm.lastLine()&&anchor.line==head.line-1&&(anchor.line==cm.firstLine()?anchor.ch=0:anchor=Pos(anchor.line-1,lineLength(cm,anchor.line-1))),text=cm.getRange(anchor,head),cm.replaceRange("",anchor,head),finalHead=anchor,args.linewise&&(finalHead=motions.moveToFirstNonWhiteSpaceCharacter(cm,anchor))}return vimGlobalState.registerController.pushText(args.registerName,"delete",text,args.linewise,vim.visualBlock),clipCursorToContent(cm,finalHead)},indent:function(cm,args,ranges){var vim=cm.state.vim,startLine=ranges[0].anchor.line,endLine=vim.visualBlock?ranges[ranges.length-1].anchor.line:ranges[0].head.line,repeat=vim.visualMode?args.repeat:1;args.linewise&&endLine--;for(var i=startLine;i<=endLine;i++)for(var j=0;j<repeat;j++)cm.indentLine(i,args.indentRight);return motions.moveToFirstNonWhiteSpaceCharacter(cm,ranges[0].anchor)},changeCase:function(cm,args,ranges,oldAnchor,newHead){for(var selections=cm.getSelections(),swapped=[],toLower=args.toLower,j=0;j<selections.length;j++){var toSwap=selections[j],text="";if(!0===toLower)text=toSwap.toLowerCase();else if(!1===toLower)text=toSwap.toUpperCase();else for(var i=0;i<toSwap.length;i++){var character=toSwap.charAt(i);text+=isUpperCase(character)?character.toLowerCase():character.toUpperCase()}swapped.push(text)}return cm.replaceSelections(swapped),args.shouldMoveCursor?newHead:!cm.state.vim.visualMode&&args.linewise&&ranges[0].anchor.line+1==ranges[0].head.line?motions.moveToFirstNonWhiteSpaceCharacter(cm,oldAnchor):args.linewise?oldAnchor:cursorMin(ranges[0].anchor,ranges[0].head)},yank:function(cm,args,ranges,oldAnchor){var vim=cm.state.vim,text=cm.getSelection(),endPos=vim.visualMode?cursorMin(vim.sel.anchor,vim.sel.head,ranges[0].head,ranges[0].anchor):oldAnchor;return vimGlobalState.registerController.pushText(args.registerName,"yank",text,args.linewise,vim.visualBlock),endPos}},actions={jumpListWalk:function(cm,actionArgs,vim){if(!vim.visualMode){var repeat=actionArgs.repeat,forward=actionArgs.forward,mark=vimGlobalState.jumpList.move(cm,forward?repeat:-repeat),markPos=mark?mark.find():void 0;markPos=markPos||cm.getCursor(),cm.setCursor(markPos)}},scroll:function(cm,actionArgs,vim){if(!vim.visualMode){var repeat=actionArgs.repeat||1,lineHeight=cm.defaultTextHeight(),top=cm.getScrollInfo().top,delta=lineHeight*repeat,newPos=actionArgs.forward?top+delta:top-delta,cursor=copyCursor(cm.getCursor()),cursorCoords=cm.charCoords(cursor,"local");if(actionArgs.forward)newPos>cursorCoords.top?(cursor.line+=(newPos-cursorCoords.top)/lineHeight,cursor.line=Math.ceil(cursor.line),cm.setCursor(cursor),cursorCoords=cm.charCoords(cursor,"local"),cm.scrollTo(null,cursorCoords.top)):cm.scrollTo(null,newPos);else{var newBottom=newPos+cm.getScrollInfo().clientHeight;newBottom<cursorCoords.bottom?(cursor.line-=(cursorCoords.bottom-newBottom)/lineHeight,cursor.line=Math.floor(cursor.line),cm.setCursor(cursor),cursorCoords=cm.charCoords(cursor,"local"),cm.scrollTo(null,cursorCoords.bottom-cm.getScrollInfo().clientHeight)):cm.scrollTo(null,newPos)}}},scrollToCursor:function(cm,actionArgs){var lineNum=cm.getCursor().line,charCoords=cm.charCoords(Pos(lineNum,0),"local"),height=cm.getScrollInfo().clientHeight,y=charCoords.top,lineHeight=charCoords.bottom-y;switch(actionArgs.position){case"center":y=y-height/2+lineHeight;break;case"bottom":y=y-height+lineHeight}cm.scrollTo(null,y)},replayMacro:function(cm,actionArgs,vim){var registerName=actionArgs.selectedCharacter,repeat=actionArgs.repeat,macroModeState=vimGlobalState.macroModeState;for("@"==registerName&&(registerName=macroModeState.latestRegister);repeat--;)executeMacroRegister(cm,vim,macroModeState,registerName)},enterMacroRecordMode:function(cm,actionArgs){var macroModeState=vimGlobalState.macroModeState,registerName=actionArgs.selectedCharacter;vimGlobalState.registerController.isValidRegister(registerName)&&macroModeState.enterMacroRecordMode(cm,registerName)},toggleOverwrite:function(cm){cm.state.overwrite?(cm.toggleOverwrite(!1),cm.setOption("keyMap","vim-insert"),CodeMirror.signal(cm,"vim-mode-change",{mode:"insert"})):(cm.toggleOverwrite(!0),cm.setOption("keyMap","vim-replace"),CodeMirror.signal(cm,"vim-mode-change",{mode:"replace"}))},enterInsertMode:function(cm,actionArgs,vim){if(!cm.getOption("readOnly")){vim.insertMode=!0,vim.insertModeRepeat=actionArgs&&actionArgs.repeat||1;var insertAt=actionArgs?actionArgs.insertAt:null,sel=vim.sel,head=actionArgs.head||cm.getCursor("head"),height=cm.listSelections().length;if("eol"==insertAt)head=Pos(head.line,lineLength(cm,head.line));else if("charAfter"==insertAt)head=offsetCursor(head,0,1);else if("firstNonBlank"==insertAt)head=motions.moveToFirstNonWhiteSpaceCharacter(cm,head);else if("startOfSelectedArea"==insertAt)vim.visualBlock?(head=Pos(Math.min(sel.head.line,sel.anchor.line),Math.min(sel.head.ch,sel.anchor.ch)),height=Math.abs(sel.head.line-sel.anchor.line)+1):head=sel.head.line<sel.anchor.line?sel.head:Pos(sel.anchor.line,0);else if("endOfSelectedArea"==insertAt)vim.visualBlock?(head=Pos(Math.min(sel.head.line,sel.anchor.line),Math.max(sel.head.ch+1,sel.anchor.ch)),height=Math.abs(sel.head.line-sel.anchor.line)+1):head=sel.head.line>=sel.anchor.line?offsetCursor(sel.head,0,1):Pos(sel.anchor.line,0);else if("inplace"==insertAt&&vim.visualMode)return;cm.setOption("disableInput",!1),actionArgs&&actionArgs.replace?(cm.toggleOverwrite(!0),cm.setOption("keyMap","vim-replace"),CodeMirror.signal(cm,"vim-mode-change",{mode:"replace"})):(cm.toggleOverwrite(!1),cm.setOption("keyMap","vim-insert"),CodeMirror.signal(cm,"vim-mode-change",{mode:"insert"})),vimGlobalState.macroModeState.isPlaying||(cm.on("change",onChange),CodeMirror.on(cm.getInputField(),"keydown",onKeyEventTargetKeyDown)),vim.visualMode&&exitVisualMode(cm),selectForInsert(cm,head,height)}},toggleVisualMode:function(cm,actionArgs,vim){var head,repeat=actionArgs.repeat,anchor=cm.getCursor();vim.visualMode?vim.visualLine^actionArgs.linewise||vim.visualBlock^actionArgs.blockwise?(vim.visualLine=!!actionArgs.linewise,vim.visualBlock=!!actionArgs.blockwise,CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""}),updateCmSelection(cm)):exitVisualMode(cm):(vim.visualMode=!0,vim.visualLine=!!actionArgs.linewise,vim.visualBlock=!!actionArgs.blockwise,head=clipCursorToContent(cm,Pos(anchor.line,anchor.ch+repeat-1),!0),vim.sel={anchor:anchor,head:head},CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""}),updateCmSelection(cm),updateMark(cm,vim,"<",cursorMin(anchor,head)),updateMark(cm,vim,">",cursorMax(anchor,head)))},reselectLastSelection:function(cm,_actionArgs,vim){var lastSelection=vim.lastSelection;if(vim.visualMode&&updateLastSelection(cm,vim),lastSelection){var anchor=lastSelection.anchorMark.find(),head=lastSelection.headMark.find();if(!anchor||!head)return;vim.sel={anchor:anchor,head:head},vim.visualMode=!0,vim.visualLine=lastSelection.visualLine,vim.visualBlock=lastSelection.visualBlock,updateCmSelection(cm),updateMark(cm,vim,"<",cursorMin(anchor,head)),updateMark(cm,vim,">",cursorMax(anchor,head)),CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""})}},joinLines:function(cm,actionArgs,vim){var curStart,curEnd;if(vim.visualMode){if(curStart=cm.getCursor("anchor"),cursorIsBefore(curEnd=cm.getCursor("head"),curStart)){var tmp=curEnd;curEnd=curStart,curStart=tmp}curEnd.ch=lineLength(cm,curEnd.line)-1}else{var repeat=Math.max(actionArgs.repeat,2);curStart=cm.getCursor(),curEnd=clipCursorToContent(cm,Pos(curStart.line+repeat-1,1/0))}for(var finalCh=0,i=curStart.line;i<curEnd.line;i++){finalCh=lineLength(cm,curStart.line);tmp=Pos(curStart.line+1,lineLength(cm,curStart.line+1));var text=cm.getRange(curStart,tmp);text=text.replace(/\n\s*/g," "),cm.replaceRange(text,curStart,tmp)}var curFinalPos=Pos(curStart.line,finalCh);vim.visualMode&&exitVisualMode(cm,!1),cm.setCursor(curFinalPos)},newLineAndEnterInsertMode:function(cm,actionArgs,vim){vim.insertMode=!0;var insertAt=copyCursor(cm.getCursor());insertAt.line!==cm.firstLine()||actionArgs.after?(insertAt.line=actionArgs.after?insertAt.line:insertAt.line-1,insertAt.ch=lineLength(cm,insertAt.line),cm.setCursor(insertAt),(CodeMirror.commands.newlineAndIndentContinueComment||CodeMirror.commands.newlineAndIndent)(cm)):(cm.replaceRange("\n",Pos(cm.firstLine(),0)),cm.setCursor(cm.firstLine(),0));this.enterInsertMode(cm,{repeat:actionArgs.repeat},vim)},paste:function(cm,actionArgs,vim){var cur=copyCursor(cm.getCursor()),register=vimGlobalState.registerController.getRegister(actionArgs.registerName);if(text=register.toString()){if(actionArgs.matchIndent){var tabSize=cm.getOption("tabSize"),whitespaceLength=function(str){var tabs=str.split("\t").length-1,spaces=str.split(" ").length-1;return tabs*tabSize+1*spaces},currentLine=cm.getLine(cm.getCursor().line),indent=whitespaceLength(currentLine.match(/^\s*/)[0]),chompedText=text.replace(/\n$/,""),wasChomped=text!==chompedText,firstIndent=whitespaceLength(text.match(/^\s*/)[0]),text=chompedText.replace(/^\s*/gm,function(wspace){var newIndent=indent+(whitespaceLength(wspace)-firstIndent);if(newIndent<0)return"";if(cm.getOption("indentWithTabs")){var quotient=Math.floor(newIndent/tabSize);return Array(quotient+1).join("\t")}return Array(newIndent+1).join(" ")});text+=wasChomped?"\n":""}if(actionArgs.repeat>1)text=Array(actionArgs.repeat+1).join(text);var curPosFinal,idx,linewise=register.linewise,blockwise=register.blockwise;if(linewise)vim.visualMode?text=vim.visualLine?text.slice(0,-1):"\n"+text.slice(0,text.length-1)+"\n":actionArgs.after?(text="\n"+text.slice(0,text.length-1),cur.ch=lineLength(cm,cur.line)):cur.ch=0;else{if(blockwise){text=text.split("\n");for(var i=0;i<text.length;i++)text[i]=""==text[i]?" ":text[i]}cur.ch+=actionArgs.after?1:0}if(vim.visualMode){var lastSelectionCurEnd;vim.lastPastedText=text;var selectedArea=getSelectedAreaRange(cm,vim),selectionStart=selectedArea[0],selectionEnd=selectedArea[1],selectedText=cm.getSelection(),selections=cm.listSelections(),emptyStrings=new Array(selections.length).join("1").split("1");vim.lastSelection&&(lastSelectionCurEnd=vim.lastSelection.headMark.find()),vimGlobalState.registerController.unnamedRegister.setText(selectedText),blockwise?(cm.replaceSelections(emptyStrings),selectionEnd=Pos(selectionStart.line+text.length-1,selectionStart.ch),cm.setCursor(selectionStart),selectBlock(cm,selectionEnd),cm.replaceSelections(text),curPosFinal=selectionStart):vim.visualBlock?(cm.replaceSelections(emptyStrings),cm.setCursor(selectionStart),cm.replaceRange(text,selectionStart,selectionStart),curPosFinal=selectionStart):(cm.replaceRange(text,selectionStart,selectionEnd),curPosFinal=cm.posFromIndex(cm.indexFromPos(selectionStart)+text.length-1)),lastSelectionCurEnd&&(vim.lastSelection.headMark=cm.setBookmark(lastSelectionCurEnd)),linewise&&(curPosFinal.ch=0)}else if(blockwise){cm.setCursor(cur);for(i=0;i<text.length;i++){var line=cur.line+i;line>cm.lastLine()&&cm.replaceRange("\n",Pos(line,0)),lineLength(cm,line)<cur.ch&&extendLineToColumn(cm,line,cur.ch)}cm.setCursor(cur),selectBlock(cm,Pos(cur.line+text.length-1,cur.ch)),cm.replaceSelections(text),curPosFinal=cur}else cm.replaceRange(text,cur),linewise&&actionArgs.after?curPosFinal=Pos(cur.line+1,findFirstNonWhiteSpaceCharacter(cm.getLine(cur.line+1))):linewise&&!actionArgs.after?curPosFinal=Pos(cur.line,findFirstNonWhiteSpaceCharacter(cm.getLine(cur.line))):!linewise&&actionArgs.after?(idx=cm.indexFromPos(cur),curPosFinal=cm.posFromIndex(idx+text.length-1)):(idx=cm.indexFromPos(cur),curPosFinal=cm.posFromIndex(idx+text.length));vim.visualMode&&exitVisualMode(cm,!1),cm.setCursor(curPosFinal)}},undo:function(cm,actionArgs){cm.operation(function(){repeatFn(cm,CodeMirror.commands.undo,actionArgs.repeat)(),cm.setCursor(cm.getCursor("anchor"))})},redo:function(cm,actionArgs){repeatFn(cm,CodeMirror.commands.redo,actionArgs.repeat)()},setRegister:function(_cm,actionArgs,vim){vim.inputState.registerName=actionArgs.selectedCharacter},setMark:function(cm,actionArgs,vim){updateMark(cm,vim,actionArgs.selectedCharacter,cm.getCursor())},replace:function(cm,actionArgs,vim){var replaceTo,curEnd,replaceWith=actionArgs.selectedCharacter,curStart=cm.getCursor(),selections=cm.listSelections();if(vim.visualMode)curStart=cm.getCursor("start"),curEnd=cm.getCursor("end");else{var line=cm.getLine(curStart.line);(replaceTo=curStart.ch+actionArgs.repeat)>line.length&&(replaceTo=line.length),curEnd=Pos(curStart.line,replaceTo)}if("\n"==replaceWith)vim.visualMode||cm.replaceRange("",curStart,curEnd),(CodeMirror.commands.newlineAndIndentContinueComment||CodeMirror.commands.newlineAndIndent)(cm);else{var replaceWithStr=cm.getRange(curStart,curEnd);if(replaceWithStr=replaceWithStr.replace(/[^\n]/g,replaceWith),vim.visualBlock){var spaces=new Array(cm.getOption("tabSize")+1).join(" ");replaceWithStr=(replaceWithStr=cm.getSelection()).replace(/\t/g,spaces).replace(/[^\n]/g,replaceWith).split("\n"),cm.replaceSelections(replaceWithStr)}else cm.replaceRange(replaceWithStr,curStart,curEnd);vim.visualMode?(curStart=cursorIsBefore(selections[0].anchor,selections[0].head)?selections[0].anchor:selections[0].head,cm.setCursor(curStart),exitVisualMode(cm,!1)):cm.setCursor(offsetCursor(curEnd,0,-1))}},incrementNumberToken:function(cm,actionArgs){for(var match,start,end,numberStr,token,cur=cm.getCursor(),lineStr=cm.getLine(cur.line),re=/-?\d+/g;null!==(match=re.exec(lineStr))&&(token=match[0],end=(start=match.index)+token.length,!(cur.ch<end)););if((actionArgs.backtrack||!(end<=cur.ch))&&token){var increment=actionArgs.increase?1:-1,number=parseInt(token)+increment*actionArgs.repeat,from=Pos(cur.line,start),to=Pos(cur.line,end);numberStr=number.toString(),cm.replaceRange(numberStr,from,to),cm.setCursor(Pos(cur.line,start+numberStr.length-1))}},repeatLastEdit:function(cm,actionArgs,vim){if(vim.lastEditInputState){var repeat=actionArgs.repeat;repeat&&actionArgs.repeatIsExplicit?vim.lastEditInputState.repeatOverride=repeat:repeat=vim.lastEditInputState.repeatOverride||repeat,repeatLastEdit(cm,vim,repeat,!1)}},indent:function(cm,actionArgs){cm.indentLine(cm.getCursor().line,actionArgs.indentRight)},exitInsertMode:exitInsertMode},symbolToMode={"(":"bracket",")":"bracket","{":"bracket","}":"bracket","[":"section","]":"section","*":"comment","/":"comment",m:"method",M:"method","#":"preprocess"},findSymbolModes={bracket:{isComplete:function(state){if(state.nextCh===state.symb){if(state.depth++,state.depth>=1)return!0}else state.nextCh===state.reverseSymb&&state.depth--;return!1}},section:{init:function(state){state.curMoveThrough=!0,state.symb=(state.forward?"]":"[")===state.symb?"{":"}"},isComplete:function(state){return 0===state.index&&state.nextCh===state.symb}},comment:{isComplete:function(state){var found="*"===state.lastCh&&"/"===state.nextCh;return state.lastCh=state.nextCh,found}},method:{init:function(state){state.symb="m"===state.symb?"{":"}",state.reverseSymb="{"===state.symb?"}":"{"},isComplete:function(state){return state.nextCh===state.symb}},preprocess:{init:function(state){state.index=0},isComplete:function(state){if("#"===state.nextCh){var token=state.lineText.match(/#(\w+)/)[1];if("endif"===token){if(state.forward&&0===state.depth)return!0;state.depth++}else if("if"===token){if(!state.forward&&0===state.depth)return!0;state.depth--}if("else"===token&&0===state.depth)return!0}return!1}}};defineOption("pcre",!0,"boolean"),SearchState.prototype={getQuery:function(){return vimGlobalState.query},setQuery:function(query){vimGlobalState.query=query},getOverlay:function(){return this.searchOverlay},setOverlay:function(overlay){this.searchOverlay=overlay},isReversed:function(){return vimGlobalState.isReversed},setReversed:function(reversed){vimGlobalState.isReversed=reversed},getScrollbarAnnotate:function(){return this.annotate},setScrollbarAnnotate:function(annotate){this.annotate=annotate}};var charUnescapes={"\\n":"\n","\\r":"\r","\\t":"\t"},unescapes={"\\/":"/","\\\\":"\\","\\n":"\n","\\r":"\r","\\t":"\t"},searchPromptDesc="(Javascript regexp)",ExCommandDispatcher=function(){this.buildCommandMap_()};ExCommandDispatcher.prototype={processCommand:function(cm,input,opt_params){var that=this;cm.operation(function(){cm.curOp.isVimOp=!0,that._processCommand(cm,input,opt_params)})},_processCommand:function(cm,input,opt_params){var vim=cm.state.vim,commandHistoryRegister=vimGlobalState.registerController.getRegister(":"),previousCommand=commandHistoryRegister.toString();vim.visualMode&&exitVisualMode(cm);var inputStream=new CodeMirror.StringStream(input);commandHistoryRegister.setText(input);var command,commandName,params=opt_params||{};params.input=input;try{this.parseInput_(cm,inputStream,params)}catch(e){throw showConfirm(cm,e),e}if(params.commandName){if(command=this.matchCommand_(params.commandName)){if(commandName=command.name,command.excludeFromCommandHistory&&commandHistoryRegister.setText(previousCommand),this.parseCommandArgs_(inputStream,params,command),"exToKey"==command.type){for(var i=0;i<command.toKeys.length;i++)CodeMirror.Vim.handleKey(cm,command.toKeys[i],"mapping");return}if("exToEx"==command.type)return void this.processCommand(cm,command.toInput)}}else void 0!==params.line&&(commandName="move");if(commandName)try{exCommands[commandName](cm,params),command&&command.possiblyAsync||!params.callback||params.callback()}catch(e){throw showConfirm(cm,e),e}else showConfirm(cm,'Not an editor command ":'+input+'"')},parseInput_:function(cm,inputStream,result){inputStream.eatWhile(":"),inputStream.eat("%")?(result.line=cm.firstLine(),result.lineEnd=cm.lastLine()):(result.line=this.parseLineSpec_(cm,inputStream),void 0!==result.line&&inputStream.eat(",")&&(result.lineEnd=this.parseLineSpec_(cm,inputStream)));var commandMatch=inputStream.match(/^(\w+)/);return result.commandName=commandMatch?commandMatch[1]:inputStream.match(/.*/)[0],result},parseLineSpec_:function(cm,inputStream){var numberMatch=inputStream.match(/^(\d+)/);if(numberMatch)return parseInt(numberMatch[1],10)-1;switch(inputStream.next()){case".":return this.parseLineSpecOffset_(inputStream,cm.getCursor().line);case"$":return this.parseLineSpecOffset_(inputStream,cm.lastLine());case"'":var markName=inputStream.next(),markPos=getMarkPos(cm,cm.state.vim,markName);if(!markPos)throw new Error("Mark not set");return this.parseLineSpecOffset_(inputStream,markPos.line);case"-":case"+":return inputStream.backUp(1),this.parseLineSpecOffset_(inputStream,cm.getCursor().line);default:return void inputStream.backUp(1)}},parseLineSpecOffset_:function(inputStream,line){var offsetMatch=inputStream.match(/^([+-])?(\d+)/);if(offsetMatch){var offset=parseInt(offsetMatch[2],10);"-"==offsetMatch[1]?line-=offset:line+=offset}return line},parseCommandArgs_:function(inputStream,params,command){if(!inputStream.eol()){params.argString=inputStream.match(/.*/)[0];var delim=command.argDelimiter||/\s+/,args=trim(params.argString).split(delim);args.length&&args[0]&&(params.args=args)}},matchCommand_:function(commandName){for(var i=commandName.length;i>0;i--){var prefix=commandName.substring(0,i);if(this.commandMap_[prefix]){var command=this.commandMap_[prefix];if(0===command.name.indexOf(commandName))return command}}return null},buildCommandMap_:function(){this.commandMap_={};for(var i=0;i<defaultExCommandMap.length;i++){var command=defaultExCommandMap[i],key=command.shortName||command.name;this.commandMap_[key]=command}},map:function(lhs,rhs,ctx){if(":"!=lhs&&":"==lhs.charAt(0)){if(ctx)throw Error("Mode not supported for ex mappings");var commandName=lhs.substring(1);":"!=rhs&&":"==rhs.charAt(0)?this.commandMap_[commandName]={name:commandName,type:"exToEx",toInput:rhs.substring(1),user:!0}:this.commandMap_[commandName]={name:commandName,type:"exToKey",toKeys:rhs,user:!0}}else if(":"!=rhs&&":"==rhs.charAt(0)){var mapping={keys:lhs,type:"keyToEx",exArgs:{input:rhs.substring(1)}};ctx&&(mapping.context=ctx),defaultKeymap.unshift(mapping)}else{mapping={keys:lhs,type:"keyToKey",toKeys:rhs};ctx&&(mapping.context=ctx),defaultKeymap.unshift(mapping)}},unmap:function(lhs,ctx){if(":"!=lhs&&":"==lhs.charAt(0)){if(ctx)throw Error("Mode not supported for ex mappings");var commandName=lhs.substring(1);if(this.commandMap_[commandName]&&this.commandMap_[commandName].user)return void delete this.commandMap_[commandName]}else for(var keys=lhs,i=0;i<defaultKeymap.length;i++)if(keys==defaultKeymap[i].keys&&defaultKeymap[i].context===ctx)return void defaultKeymap.splice(i,1);throw Error("No such mapping.")}};var exCommands={colorscheme:function(cm,params){!params.args||params.args.length<1?showConfirm(cm,cm.getOption("theme")):cm.setOption("theme",params.args[0])},map:function(cm,params,ctx){var mapArgs=params.args;!mapArgs||mapArgs.length<2?cm&&showConfirm(cm,"Invalid mapping: "+params.input):exCommandDispatcher.map(mapArgs[0],mapArgs[1],ctx)},imap:function(cm,params){this.map(cm,params,"insert")},nmap:function(cm,params){this.map(cm,params,"normal")},vmap:function(cm,params){this.map(cm,params,"visual")},unmap:function(cm,params,ctx){var mapArgs=params.args;!mapArgs||mapArgs.length<1?cm&&showConfirm(cm,"No such mapping: "+params.input):exCommandDispatcher.unmap(mapArgs[0],ctx)},move:function(cm,params){commandDispatcher.processCommand(cm,cm.state.vim,{type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!1,explicitRepeat:!0,linewise:!0},repeatOverride:params.line+1})},set:function(cm,params){var setArgs=params.args,setCfg=params.setCfg||{};if(!setArgs||setArgs.length<1)cm&&showConfirm(cm,"Invalid mapping: "+params.input);else{var expr=setArgs[0].split("="),optionName=expr[0],value=expr[1],forceGet=!1;if("?"==optionName.charAt(optionName.length-1)){if(value)throw Error("Trailing characters: "+params.argString);optionName=optionName.substring(0,optionName.length-1),forceGet=!0}void 0===value&&"no"==optionName.substring(0,2)&&(optionName=optionName.substring(2),value=!1);var optionIsBoolean=options[optionName]&&"boolean"==options[optionName].type;if(optionIsBoolean&&null==value&&(value=!0),!optionIsBoolean&&void 0===value||forceGet){var oldValue=getOption(optionName,cm,setCfg);oldValue instanceof Error?showConfirm(cm,oldValue.message):showConfirm(cm,!0===oldValue||!1===oldValue?" "+(oldValue?"":"no")+optionName:"  "+optionName+"="+oldValue)}else{var setOptionReturn=setOption(optionName,value,cm,setCfg);setOptionReturn instanceof Error&&showConfirm(cm,setOptionReturn.message)}}},setlocal:function(cm,params){params.setCfg={scope:"local"},this.set(cm,params)},setglobal:function(cm,params){params.setCfg={scope:"global"},this.set(cm,params)},registers:function(cm,params){var regArgs=params.args,registers=vimGlobalState.registerController.registers,regInfo="----------Registers----------<br><br>";if(regArgs){regArgs=regArgs.join("");for(var i=0;i<regArgs.length;i++){if(registerName=regArgs.charAt(i),vimGlobalState.registerController.isValidRegister(registerName))regInfo+='"'+registerName+"    "+(registers[registerName]||new Register).toString()+"<br>"}}else for(var registerName in registers){var text=registers[registerName].toString();text.length&&(regInfo+='"'+registerName+"    "+text+"<br>")}showConfirm(cm,regInfo)},sort:function(cm,params){function parseArgs(){if(params.argString){var args=new CodeMirror.StringStream(params.argString);if(args.eat("!")&&(reverse=!0),args.eol())return;if(!args.eatSpace())return"Invalid arguments";var opts=args.match(/([dinuox]+)?\s*(\/.+\/)?\s*/);if(!opts&&!args.eol())return"Invalid arguments";if(opts[1]){ignoreCase=-1!=opts[1].indexOf("i"),unique=-1!=opts[1].indexOf("u");var decimal=-1!=opts[1].indexOf("d")||-1!=opts[1].indexOf("n")&&1,hex=-1!=opts[1].indexOf("x")&&1,octal=-1!=opts[1].indexOf("o")&&1;if(decimal+hex+octal>1)return"Invalid arguments";number=(decimal?"decimal":hex&&"hex")||octal&&"octal"}opts[2]&&(pattern=new RegExp(opts[2].substr(1,opts[2].length-2),ignoreCase?"i":""))}}function compareFn(a,b){var tmp;reverse&&(tmp=a,a=b,b=tmp);ignoreCase&&(a=a.toLowerCase(),b=b.toLowerCase());var anum=number&&numberRegex.exec(a),bnum=number&&numberRegex.exec(b);return anum?(anum=parseInt((anum[1]+anum[2]).toLowerCase(),radix))-(bnum=parseInt((bnum[1]+bnum[2]).toLowerCase(),radix)):a<b?-1:1}function comparePatternFn(a,b){var tmp;reverse&&(tmp=a,a=b,b=tmp);return ignoreCase&&(a[0]=a[0].toLowerCase(),b[0]=b[0].toLowerCase()),a[0]<b[0]?-1:1}var reverse,ignoreCase,unique,number,pattern,err=parseArgs();if(err)showConfirm(cm,err+": "+params.argString);else{var lineStart=params.line||cm.firstLine(),lineEnd=params.lineEnd||params.line||cm.lastLine();if(lineStart!=lineEnd){var curStart=Pos(lineStart,0),curEnd=Pos(lineEnd,lineLength(cm,lineEnd)),text=cm.getRange(curStart,curEnd).split("\n"),numberRegex=pattern||("decimal"==number?/(-?)([\d]+)/:"hex"==number?/(-?)(?:0x)?([0-9a-f]+)/i:"octal"==number?/([0-7]+)/:null),radix="decimal"==number?10:"hex"==number?16:"octal"==number?8:null,numPart=[],textPart=[];if(number||pattern)for(var i=0;i<text.length;i++){var matchPart=pattern?text[i].match(pattern):null;matchPart&&""!=matchPart[0]?numPart.push(matchPart):!pattern&&numberRegex.exec(text[i])?numPart.push(text[i]):textPart.push(text[i])}else textPart=text;if(numPart.sort(pattern?comparePatternFn:compareFn),pattern)for(i=0;i<numPart.length;i++)numPart[i]=numPart[i].input;else number||textPart.sort(compareFn);if(text=reverse?numPart.concat(textPart):textPart.concat(numPart),unique){var lastLine,textOld=text;text=[];for(i=0;i<textOld.length;i++)textOld[i]!=lastLine&&text.push(textOld[i]),lastLine=textOld[i]}cm.replaceRange(text.join("\n"),curStart,curEnd)}}},global:function(cm,params){var argString=params.argString;if(argString){var cmd,lineStart=void 0!==params.line?params.line:cm.firstLine(),lineEnd=params.lineEnd||params.line||cm.lastLine(),tokens=splitBySlash(argString),regexPart=argString;if(tokens.length&&(regexPart=tokens[0],cmd=tokens.slice(1,tokens.length).join("/")),regexPart)try{updateSearchQuery(cm,regexPart,!0,!0)}catch(e){return void showConfirm(cm,"Invalid regex: "+regexPart)}for(var query=getSearchState(cm).getQuery(),matchedLines=[],content="",i=lineStart;i<=lineEnd;i++){query.test(cm.getLine(i))&&(matchedLines.push(i+1),content+=cm.getLine(i)+"<br>")}if(cmd){var index=0,nextCommand=function(){if(index<matchedLines.length){var command=matchedLines[index]+cmd;exCommandDispatcher.processCommand(cm,command,{callback:nextCommand})}index++};nextCommand()}else showConfirm(cm,content)}else showConfirm(cm,"Regular Expression missing from global")},substitute:function(cm,params){if(!cm.getSearchCursor)throw new Error("Search feature not available. Requires searchcursor.js or any other getSearchCursor implementation.");var regexPart,trailing,flagsPart,count,argString=params.argString,tokens=argString?splitBySlash(argString):[],replacePart="",confirm=!1,global=!1;if(tokens.length)regexPart=tokens[0],replacePart=tokens[1],regexPart&&"$"===regexPart[regexPart.length-1]&&(regexPart=regexPart.slice(0,regexPart.length-1)+"\\n",replacePart=replacePart?replacePart+"\n":"\n"),void 0!==replacePart&&(replacePart=getOption("pcre")?unescapeRegexReplace(replacePart):translateRegexReplace(replacePart),vimGlobalState.lastSubstituteReplacePart=replacePart),trailing=tokens[2]?tokens[2].split(" "):[];else if(argString&&argString.length)return void showConfirm(cm,"Substitutions should be of the form :s/pattern/replace/");if(trailing&&(flagsPart=trailing[0],count=parseInt(trailing[1]),flagsPart&&(-1!=flagsPart.indexOf("c")&&(confirm=!0,flagsPart.replace("c","")),-1!=flagsPart.indexOf("g")&&(global=!0,flagsPart.replace("g","")),regexPart=regexPart+"/"+flagsPart)),regexPart)try{updateSearchQuery(cm,regexPart,!0,!0)}catch(e){return void showConfirm(cm,"Invalid regex: "+regexPart)}if(void 0!==(replacePart=replacePart||vimGlobalState.lastSubstituteReplacePart)){var query=getSearchState(cm).getQuery(),lineStart=void 0!==params.line?params.line:cm.getCursor().line,lineEnd=params.lineEnd||lineStart;lineStart==cm.firstLine()&&lineEnd==cm.lastLine()&&(lineEnd=1/0),count&&(lineEnd=(lineStart=lineEnd)+count-1);var startPos=clipCursorToContent(cm,Pos(lineStart,0));doReplace(cm,confirm,global,lineStart,lineEnd,cm.getSearchCursor(query,startPos),query,replacePart,params.callback)}else showConfirm(cm,"No previous substitute regular expression")},redo:CodeMirror.commands.redo,undo:CodeMirror.commands.undo,write:function(cm){CodeMirror.commands.save?CodeMirror.commands.save(cm):cm.save&&cm.save()},nohlsearch:function(cm){clearSearchHighlight(cm)},yank:function(cm){var line=copyCursor(cm.getCursor()).line,lineText=cm.getLine(line);vimGlobalState.registerController.pushText("0","yank",lineText,!0,!0)},delmarks:function(cm,params){if(params.argString&&trim(params.argString))for(var state=cm.state.vim,stream=new CodeMirror.StringStream(trim(params.argString));!stream.eol();){stream.eatSpace();var count=stream.pos;if(!stream.match(/[a-zA-Z]/,!1))return void showConfirm(cm,"Invalid argument: "+params.argString.substring(count));var sym=stream.next();if(stream.match("-",!0)){if(!stream.match(/[a-zA-Z]/,!1))return void showConfirm(cm,"Invalid argument: "+params.argString.substring(count));var startMark=sym,finishMark=stream.next();if(!(isLowerCase(startMark)&&isLowerCase(finishMark)||isUpperCase(startMark)&&isUpperCase(finishMark)))return void showConfirm(cm,"Invalid argument: "+startMark+"-");var start=startMark.charCodeAt(0),finish=finishMark.charCodeAt(0);if(start>=finish)return void showConfirm(cm,"Invalid argument: "+params.argString.substring(count));for(var j=0;j<=finish-start;j++){var mark=String.fromCharCode(start+j);delete state.marks[mark]}}else delete state.marks[sym]}else showConfirm(cm,"Argument required")}},exCommandDispatcher=new ExCommandDispatcher;return CodeMirror.keyMap.vim={attach:attachVimMap,detach:detachVimMap,call:cmKey},defineOption("insertModeEscKeysTimeout",200,"number"),CodeMirror.keyMap["vim-insert"]={fallthrough:["default"],attach:attachVimMap,detach:detachVimMap,call:cmKey},CodeMirror.keyMap["vim-replace"]={Backspace:"goCharLeft",fallthrough:["vim-insert"],attach:attachVimMap,detach:detachVimMap,call:cmKey},resetVimGlobalState(),vimApi};CodeMirror.Vim=Vim()});